/* contexts.cpp
 * Context finders: functions that find the current clef, key, and time
 * signature contexts for the measures being displayed
 *
 * These functions are also invoked when a staff is created
 * 
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002 Matthew Hiller, Adam Tee
 */

#include "contexts.h"
#include "drawingprims.h"
#include "objops.h"
#include "staffops.h"

/**
 * This function finds the first mudelaobject of type thetype before measure
 * curmeasure. It returns NULL if it was unable to find such a mudelaobject 
 */
static mudelaobject *
find_context (measurenode * curmeasure, gint thetype)
{
  objnode *curobj;

  curmeasure = curmeasure->prev;
  if (!curmeasure)
    return NULL;
  curobj = lastobjnode (curmeasure);
  while (1)
    {
      while (!curobj)
	{			/* Cycle back to preceding measure */
	  if (!curmeasure->prev)
	    return NULL;	/* That is, we've fallen off the beginnig */
	  curmeasure = curmeasure->prev;
	  curobj = lastobjnode (curmeasure);
	}
      if (((mudelaobject *) curobj->data)->type == thetype)
	return (mudelaobject *)curobj->data;
      else
	curobj = curobj->prev;
    }
}

void
find_leftmost_staffcontext (staff * curstaffstruct, struct scoreinfo *si)
{
  measurenode *leftmeasure = g_list_nth (curstaffstruct->measures,
					 si->leftmeasurenum - 1);
  mudelaobject *obj;

  if ((obj = find_context (leftmeasure, CLEF)))
    curstaffstruct->leftmost_clefcontext = ((clef *)obj->object)->type;
  else
    curstaffstruct->leftmost_clefcontext = curstaffstruct->sclef;
  if ((obj = find_context (leftmeasure, KEYSIG)))
    curstaffstruct->leftmost_keysigcontext = ((keysig *)obj->object)->number;
  else
    curstaffstruct->leftmost_keysigcontext = curstaffstruct->skey;
  initkeyaccs (curstaffstruct->leftmost_keyaccs,
	       curstaffstruct->leftmost_keysigcontext);
  curstaffstruct->leftmost_keywidth =
    draw_key (NULL, NULL, 0, 0, curstaffstruct->leftmost_keysigcontext,
	      0, 0, FALSE);
  if ((obj = find_context (leftmeasure, TIMESIG)))
    {
      curstaffstruct->leftmost_time1context = ((timesig *)obj->object)->time1;
      curstaffstruct->leftmost_time2context = ((timesig *)obj->object)->time2;
    }
  else
    {
      curstaffstruct->leftmost_time1context = curstaffstruct->stime1;
      curstaffstruct->leftmost_time2context = curstaffstruct->stime2;
    }
  if ((obj = find_context (leftmeasure, STEMDIRECTIVE)))
    curstaffstruct->leftmost_stem_directive = 
      ((stemdirective *)obj->object)->type;
  else
    curstaffstruct->leftmost_stem_directive = DENEMO_STEMBOTH;
}

void
find_leftmost_allcontexts (struct scoreinfo *si)
{
  staffnode *curstaff = si->thescore;

  si->maxkeywidth = G_MININT;
  for (; curstaff; curstaff = curstaff->next)
    {
      find_leftmost_staffcontext ((staff *)curstaff->data, si);
      si->maxkeywidth = MAX (si->maxkeywidth,
			     ((staff *) curstaff->data)->leftmost_keywidth);
    }
}
