/* drawcursor.cpp
 * functions for drawing the cursor
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002  Matthew Hiller, Adam Tee
 */

#include "drawingprims.h"
#include "gcs.h"
#include "utils.h"

#define CURSOR_MINUS 2
#define CURSOR_WIDTH 10
#define CURSOR_HEIGHT 5

void
draw_cursor (GdkPixmap * pixmap, struct scoreinfo *si,
	     gint xx, gint y, gint dclef)
{
  gint height = calculateheight (si->cursor_y, dclef);
  static GdkGC *blackgc = NULL;
  static GdkGC *graygc;
  static GdkGC *greengc;
  static GdkGC *redgc;
  GdkGC *paintgc;

  if (!blackgc)
    {
      blackgc = gcs_blackgc ();
      graygc = gcs_graygc ();
      greengc = gcs_greengc ();
      redgc = gcs_redgc ();
    }

  paintgc = (si->mode == INPUTREST) ? graygc : 
    si->cursoroffend ? redgc : greengc;
  gdk_draw_rectangle (pixmap, paintgc, TRUE, xx, height + y - CURSOR_MINUS,
		      CURSOR_WIDTH, CURSOR_HEIGHT);

  /* Now draw ledgers if necessary and we're done */
  draw_ledgers (pixmap, blackgc, height, height, xx, y, CURSOR_WIDTH);
}
