
/*  A Bison parser, made from ./frogparser.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define yyparse frogparse
#define yylex froglex
#define yyerror frogerror
#define yylval froglval
#define yychar frogchar
#define yydebug frogdebug
#define yynerrs frognerrs
#define	STAFFNAME	257
#define	TIE	258
#define	END	259
#define	FLOAT	260
#define	NOTENAME	261
#define	DURATION	262
#define	RESTTYPE	263
#define	DIRECTION	264
#define	SLURPOSITION	265
#define	NUMPOSITION	266
#define	KEYTYPE	267
#define	NUM	268
#define	BRACKET	269
#define	CLEFTYPE	270
#define	ORNAMENT	271
#define	FULL	272
#define	PARTIAL	273
#define	MODE	274
#define	BARTYPE	275
#define	TEMPOTERM	276
#define	TRANSTEMPO	277
#define	DYN	278
#define	ACCIDENTAL	279
#define	ACCENT	280
#define	NOTEHEAD	281
#define	STYLE	282
#define	CURVESHAPE	283
#define	SYSTEM	284
#define	STAFFGROUP	285
#define	STAFF	286
#define	ENDSTAFFGROUP	287
#define	TUPLET	288
#define	TUP_END	289
#define	SLURTYPE	290
#define	HAIRPINTYPE	291

#line 1 "./frogparser.y"

/*
	(c) 2000  Adam Tee  <eenajt@electeng.leeds.ac.uk>
	(c) 2000  University of Leeds 
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include "frogdefs.h"
#include "redefs.h"
#include "contexts.h"
#include "file.h"
#include "frogio.h"
#include "draw.h"
#include "keyresponses.h"
#include "chordops.h"
#include "scoreops.h"
#include "staffops.h"
#include "dialogs.h"
#include "measureops.h"
#include "calculatepositions.h"
#include "objops.h"
#include "processstaffname.h"
#include "tupletops.h"
#include "dynamic.h"

#define yyin frogin
#define yytext frogtext
#define YYDEBUG 0
#define YYMAXDEPTH 100000
#define YYINITDEPTH 500
  objnode *currentobject;
  extern int errcount;

  static struct scoreinfo *frogsi;

  extern int yylex (void);
  int yyerror (char *);

  static void
    newnoteobj (struct p_note *thenote, gfloat length, struct scoreinfo *si);

  static void newclef (char *clefname);

  static void newkeysigobj (char *keyname);

  static void newtimesig (int upper, int lower);

  static void newdynamic (gchar * type);

  static enum headtype setnoteheadtype (gchar * type);
  optionlist *createoption(struct p_modifier option);
  void emptylist(optionlist *head) ;
  void insertoption(optionlist **header, optionlist *newitem);

#line 60 "./frogparser.y"
typedef union
{
  gfloat f;
  char string[FROG_MAX_TOKEN_STRING];
  int number;
  char character;
  struct p_pitch t_pitch;
  optionlist *t_option;
  struct p_note t_note;
  struct p_modifier t_modifier;
  struct p_position t_position;
  struct p_grace t_grace;
  struct p_beam t_beamd;
  struct p_beam_type t_beamtype;
  struct p_gracenoteoption t_graceoption;
  struct p_staff t_staff;
  struct p_rest t_rest;
  struct p_tupops t_tupops;
  struct p_slur t_slur;
  struct p_hairpin t_hairpin;
} YYSTYPE;
#line 151 "./frogparser.y"

  staff *thestaffstruct = NULL;
  

  measurenode *themeasures = NULL;
  gint cleftype;
  static int counter = 0;
  static int n = 1;
  static int currentbar=1;
  static gfloat beatnum = 0;
  static gfloat totaldurs = 0;
  static gint staffnum = 0;
  gboolean is_tup = FALSE;
  static gfloat currentbeat = 0;
  gint no_of_options = 0;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		144
#define	YYFLAG		-32768
#define	YYNTBASE	42

#define YYTRANSLATE(x) ((unsigned)(x) <= 291 ? yytranslate[x] : 94)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    40,    38,     2,     2,    41,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    39,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     3,     5,     7,     8,    13,    15,    19,    21,    23,
    27,    29,    34,    38,    39,    43,    45,    47,    49,    51,
    53,    55,    57,    59,    61,    63,    65,    69,    72,    75,
    77,    80,    82,    87,    90,    92,    94,    96,    98,   100,
   101,   105,   107,   109,   111,   113,   115,   117,   119,   121,
   123,   125,   132,   135,   138,   141,   144,   147,   150,   152,
   154,   156,   159,   162,   164,   166,   168,   171,   174,   177,
   181,   183,   188,   190,   192,   194,   196,   199,   201,   204,
   206,   208,   210,   212,   216,   218,   220,   222,   224,   228,
   230,   234,   240,   242
};

static const short yyrhs[] = {    43,
    45,     0,    30,     0,    15,     0,     0,    44,    46,    45,
    47,     0,    48,     0,    48,    45,    47,     0,    31,     0,
    33,     0,    49,    50,    51,     0,    32,     0,     3,    88,
    93,    89,     0,    52,    55,    51,     0,     0,    53,    54,
    56,     0,    14,     0,     6,     0,    57,     0,    77,     0,
    16,     0,    91,     0,    21,     0,    24,     0,    84,     0,
    79,     0,    78,     0,     6,    38,     6,     0,    59,     6,
     0,    58,     6,     0,    75,     0,     9,    67,     0,     9,
     0,    60,    62,    64,    70,     0,     7,    61,     0,    92,
     0,    14,     0,    63,     0,     5,     0,    10,     0,     0,
    64,    65,    56,     0,    25,     0,    26,     0,    28,     0,
    14,     0,    17,     0,    68,     0,     4,     0,    27,     0,
     4,     0,    14,     0,    60,    62,    69,    70,     6,    56,
     0,    25,    56,     0,    26,    56,     0,    28,    56,     0,
    67,    56,     0,    17,    56,     0,    66,    56,     0,    71,
     0,    72,     0,     5,     0,    73,    10,     0,    74,    10,
     0,    10,     0,    18,     0,    19,     0,    34,    76,     0,
    34,    35,     0,    14,    14,     0,    36,    56,    29,     0,
    37,     0,    80,    81,    82,    83,     0,    20,     0,    13,
     0,    14,     0,    14,     0,     7,    82,     0,     5,     0,
     7,    83,     0,     5,     0,    85,     0,    87,     0,    86,
     0,     6,    39,    14,     0,    22,     0,    23,     0,    14,
     0,    14,     0,    14,    40,    90,     0,    14,     0,    90,
    41,    14,     0,    90,    41,    14,    40,    91,     0,    14,
     0,    14,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   169,   171,   178,   183,   185,   186,   186,   188,   195,   202,
   212,   230,   245,   245,   247,   281,   288,   295,   295,   321,
   325,   326,   327,   338,   339,   340,   367,   376,   397,   432,
   434,   442,   450,   463,   470,   477,   484,   489,   495,   502,
   511,   522,   523,   524,   525,   529,   530,   531,   532,   536,
   542,   550,   563,   570,   577,   584,   590,   597,   605,   610,
   615,   622,   629,   638,   645,   652,   659,   680,   703,   713,
   722,   727,   728,   729,   732,   735,   738,   739,   742,   743,
   746,   746,   748,   748,   755,   762,   769,   776,   783,   788,
   795,   800,   807,   814
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","STAFFNAME",
"TIE","END","FLOAT","NOTENAME","DURATION","RESTTYPE","DIRECTION","SLURPOSITION",
"NUMPOSITION","KEYTYPE","NUM","BRACKET","CLEFTYPE","ORNAMENT","FULL","PARTIAL",
"MODE","BARTYPE","TEMPOTERM","TRANSTEMPO","DYN","ACCIDENTAL","ACCENT","NOTEHEAD",
"STYLE","CURVESHAPE","SYSTEM","STAFFGROUP","STAFF","ENDSTAFFGROUP","TUPLET",
"TUP_END","SLURTYPE","HAIRPINTYPE","','","'='","'+'","'/'","system","symbol",
"brace","staffgroup","staffgroupsym","endstaffsym","staffspec","staffsym","staffparams",
"musicalobject","characteristics","barnumber","beatnumber","musicalobjects",
"position","durationobject","rest","note","pitch","octave","stem_dir","directions",
"note_option","modifier_note_type","tie","dot","grace_notes","grace_note_option",
"beam","beam_type","flag","primary","secondary","tuplet","tuplet_option","slur",
"hairpin","keysignature","no_of_sharps","no_of_flats","name_of_sharps","name_of_flats",
"tempo","stationary","tempo_term","transitional","no_of_lines","transposition",
"additive","timesignature","number_of_half_lines","position_in_half_lines", NULL
};
#endif

static const short yyr1[] = {     0,
    42,    43,    44,    44,    45,    45,    45,    46,    47,    48,
    49,    50,    51,    51,    52,    53,    54,    55,    55,    55,
    55,    55,    55,    55,    55,    55,    56,    57,    57,    57,
    58,    58,    59,    60,    60,    61,    62,    62,    63,    64,
    64,    65,    65,    65,    65,    65,    65,    65,    65,    66,
    67,    68,    69,    69,    69,    69,    69,    69,    70,    70,
    70,    71,    71,    72,    73,    74,    75,    75,    76,    77,
    78,    79,    79,    79,    80,    81,    82,    82,    83,    83,
    84,    84,    85,    85,    86,    87,    88,    89,    90,    90,
    91,    91,    92,    93
};

static const short yyr2[] = {     0,
     2,     1,     1,     0,     4,     1,     3,     1,     1,     3,
     1,     4,     3,     0,     3,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     3,     2,     2,     1,
     2,     1,     4,     2,     1,     1,     1,     1,     1,     0,
     3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     6,     2,     2,     2,     2,     2,     2,     1,     1,
     1,     2,     2,     1,     1,     1,     2,     2,     2,     3,
     1,     4,     1,     1,     1,     1,     2,     1,     2,     1,
     1,     1,     1,     3,     1,     1,     1,     1,     3,     1,
     3,     5,     1,     1
};

static const short yydefact[] = {     0,
     2,     4,     3,    11,     0,     1,     6,     0,     8,     4,
     0,     0,    14,     0,     9,     7,    87,     0,    16,    10,
     0,     0,     5,    94,     0,     0,     0,    32,    74,    93,
    20,    73,    22,    85,    86,    23,     0,     0,    71,    14,
    18,     0,     0,     0,    30,    19,    26,    25,     0,    24,
    81,    83,    82,     0,    21,    35,    17,     0,    88,    12,
     0,    36,    34,    51,    31,     0,     0,    68,    67,     0,
     0,    13,    29,    28,    38,    39,    40,    37,    76,     0,
     0,    15,    84,    90,    89,    69,     0,    70,     0,    78,
     0,     0,    91,    27,    48,    61,    64,    93,    46,    65,
    66,    42,    43,    49,    44,     0,     0,    47,    33,    59,
    60,     0,     0,    77,    80,     0,    72,     0,     0,    41,
    62,    63,    79,    92,    50,     0,     0,     0,     0,     0,
     0,     0,    57,    53,    54,    55,    58,    56,     0,     0,
    52,     0,     0,     0
};

static const short yydefgoto[] = {   142,
     2,     5,     6,    10,    16,     7,     8,    13,    20,    21,
    22,    58,    40,    71,    41,    42,    43,    44,    63,    77,
    78,    89,   107,   130,    65,   108,   132,   109,   110,   111,
   112,   113,    45,    69,    46,    47,    48,    49,    80,    92,
   117,    50,    51,    52,    53,    18,    60,    54,    55,    56,
    25
};

static const short yypact[] = {    -3,
-32768,    -9,-32768,-32768,    -1,-32768,   -10,    32,-32768,    -9,
     6,    22,    28,     6,-32768,-32768,-32768,    30,-32768,-32768,
    -5,    39,-32768,-32768,    34,    17,    43,    48,-32768,    -7,
-32768,-32768,-32768,-32768,-32768,-32768,   -11,    58,-32768,    28,
-32768,    59,    61,    15,-32768,-32768,-32768,-32768,    62,-32768,
-32768,-32768,-32768,    37,-32768,-32768,-32768,    58,-32768,-32768,
    65,-32768,-32768,-32768,-32768,    66,    67,-32768,-32768,    45,
    55,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,     7,
    71,-32768,-32768,    46,-32768,-32768,    81,-32768,    33,-32768,
     7,    21,    50,-32768,-32768,-32768,-32768,    82,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,    15,    58,-32768,-32768,-32768,
-32768,    79,    83,-32768,-32768,    21,-32768,    66,    49,-32768,
-32768,-32768,-32768,-32768,-32768,    58,    58,    58,    58,    58,
    58,    36,-32768,-32768,-32768,-32768,-32768,-32768,    85,    58,
-32768,    92,    94,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,     3,-32768,    84,-32768,-32768,-32768,    56,-32768,
-32768,-32768,-32768,   -58,-32768,-32768,-32768,     8,-32768,    -6,
-32768,-32768,-32768,-32768,   -24,-32768,-32768,   -33,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,    10,
   -14,-32768,-32768,-32768,-32768,-32768,-32768,    38,   -15,-32768,
-32768
};


#define	YYLAST		104


static const short yytable[] = {    82,
    26,    27,    67,    28,     3,     3,   -75,    29,    30,    11,
    31,    90,    14,    91,    32,    33,    34,    35,    36,    75,
    -4,     4,     4,    68,    76,   115,     1,   116,    37,     9,
    38,    39,    66,   -90,    12,    17,    95,    96,    15,    27,
    96,    19,    97,    24,    57,    97,    98,    59,   120,    99,
   100,   101,   125,   100,   101,    61,    62,   102,   103,   104,
   105,    64,    64,    70,    73,   126,    74,   133,   134,   135,
   136,   137,   138,   127,   128,    79,   129,    81,    83,    84,
    86,   141,    87,    88,    93,    66,    94,   -45,   121,   118,
   140,   143,   122,   144,   131,    72,   106,    23,   139,   119,
   114,   123,   124,    85
};

static const short yycheck[] = {    58,
     6,     7,    14,     9,    15,    15,    14,    13,    14,     7,
    16,     5,    10,     7,    20,    21,    22,    23,    24,     5,
    31,    32,    32,    35,    10,     5,    30,     7,    34,    31,
    36,    37,    40,    41,     3,    14,     4,     5,    33,     7,
     5,    14,    10,    14,     6,    10,    14,    14,   107,    17,
    18,    19,     4,    18,    19,    39,    14,    25,    26,    27,
    28,    14,    14,     6,     6,    17,     6,   126,   127,   128,
   129,   130,   131,    25,    26,    14,    28,    41,    14,    14,
    14,   140,    38,    29,    14,    40,     6,     6,    10,    40,
     6,     0,    10,     0,   119,    40,    89,    14,   132,   106,
    91,   116,   118,    66
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 172 "./frogparser.y"
{
  fprintf (stderr, "Found %c \n", yyvsp[0]. character );
;
    break;}
case 3:
#line 179 "./frogparser.y"
{
 
;
    break;}
case 8:
#line 189 "./frogparser.y"
{

;
    break;}
case 9:
#line 196 "./frogparser.y"
{

;
    break;}
case 10:
#line 203 "./frogparser.y"
{

  /*p_newstaff(frogsi, &$2); */
;
    break;}
case 11:
#line 213 "./frogparser.y"
{

  frogsi->currentstaffnum++;
  newstaff (frogsi, ADDFROMLOAD, NULL);
  frogsi->currentstaff = g_list_last (frogsi->thescore);
  n = 1;
  currentbar = 1;
  staffnum++;
  counter = 0;
  frogsi->cursor_x = 0;
  totaldurs = 0;
  beatnum = 0;
  currentbeat = 0;
;
    break;}
case 12:
#line 231 "./frogparser.y"
{

  g_string_assign (((staff *) frogsi->currentstaff->data)->lily_name, yyvsp[-3]. string );
  set_denemo_name (((staff *) frogsi->currentstaff->data)->lily_name,
		   ((staff *) frogsi->currentstaff->data)->denemo_name);
  ((staff *) frogsi->currentstaff->data)->no_of_lines = yyvsp[-2]. number ;
  ((staff *) frogsi->currentstaff->data)->transposition = yyvsp[0]. number ;
  ((staff *) frogsi->currentstaff->data)->pos_in_half_lines = yyvsp[-1]. number ;


;
    break;}
case 15:
#line 248 "./frogparser.y"
{
 
  if (n != yyvsp[-2]. number )
    {
      currentbar = yyvsp[-2]. number ;
      if (!frogsi->currentmeasure->next)
	{
	  frogsi->currentmeasure = addmeasures
	    (frogsi, frogsi->currentmeasurenum, 1);
	}
      else
	{
	  frogsi->currentmeasure = frogsi->currentmeasure->next;
	}

      frogsi->currentmeasurenum++;
      frogsi->cursor_x = 0;
      
      totaldurs = 0;
      currentbeat = 0;
      beatnum = 0;
      
    }
  counter++;
  n = yyvsp[-2]. number ;
  currentbeat = yyvsp[-1]. f ;



;
    break;}
case 16:
#line 282 "./frogparser.y"
{
  yyval. number  = yyvsp[0]. number ;
;
    break;}
case 17:
#line 289 "./frogparser.y"
{
  yyval. f  = yyvsp[0]. f ;
;
    break;}
case 19:
#line 296 "./frogparser.y"
{

  mudelaobject *obj = (mudelaobject *)
    (frogsi->currentobject ? frogsi->currentobject->data : NULL);
  printf ("Found Slur\n");
  if (obj && (obj->type == CHORD))
    {
      if (strcmp (yyvsp[0]. t_slur .string, "slur_begin") == 0)
	{
	  ((chord *)obj->object)->slur_begin_p = 
	    !((chord *)obj->object)->slur_begin_p;
	  /*obj->u.chordval.slur_end_p == FALSE; */
	  printf ("Current start slur val: %d\n",
		  ((chord *)obj->object)->slur_begin_p);
	}
      else if (strcmp (yyvsp[0]. t_slur .string, "slur_end") == 0)
	{
	  ((chord *)obj->object)->slur_end_p =
	    !((chord *)obj->object)->slur_end_p;
	  /*obj->u.chordval.slur_begin_p == FALSE; */
	  printf ("Current end slur val: %d\n", 
		  ((chord *)obj->object)->slur_end_p);
	}
    }
;
    break;}
case 20:
#line 322 "./frogparser.y"
{
  newclef (yyvsp[0]. string );
;
    break;}
case 22:
#line 326 "./frogparser.y"
{ ;
    break;}
case 23:
#line 328 "./frogparser.y"
{
  GString *dynamic = g_string_new(yyvsp[0]. string );
  mudelaobject *obj = (mudelaobject *)
    (frogsi->currentobject ? frogsi->currentobject->data : NULL);
  add_dynamic(obj, dynamic);  
  
  
 /* newdynamic ($1);*/
;
    break;}
case 26:
#line 341 "./frogparser.y"
{
  mudelaobject *obj = (mudelaobject *)
    (frogsi->currentobject ? frogsi->currentobject->data : NULL);
  printf ("Found Hairpin\n");
  if (obj && (obj->type == CHORD))
    {
      if (strcmp (yyvsp[0]. t_hairpin .string, "cresc_begin") == 0)
	((chord *)obj->object)->crescendo_begin_p = 
	  !((chord *)obj->object)->crescendo_begin_p;
      else if (strcmp (yyvsp[0]. t_hairpin .string, "cresc_end") == 0)
	((chord *)obj->object)->crescendo_end_p = 
	  !((chord *)obj->object)->crescendo_end_p;
	 
      if (strcmp (yyvsp[0]. t_hairpin .string, "dim_begin") == 0)
	((chord *)obj->object)->diminuendo_begin_p =
	  !((chord *)obj->object)->diminuendo_begin_p;
      else if (strcmp (yyvsp[0]. t_hairpin .string, "dim_end") == 0)
	((chord *)obj->object)->diminuendo_end_p = 
	  !((chord *)obj->object)->diminuendo_end_p;
	
      
    }


;
    break;}
case 27:
#line 368 "./frogparser.y"
{
  yyval. t_position .xoff = yyvsp[-2]. f ;
  yyval. t_position .yoff = yyvsp[0]. f ;
  
;
    break;}
case 28:
#line 377 "./frogparser.y"
{
  if (currentbeat == beatnum && n == currentbar)
    {
      totaldurs = beatnum;
    }
  else
    {
      beatnum = currentbeat;
    }

#ifdef DEBUG
  printf("JTF Duration %f\n", yyvsp[0]. f );
  printf("Current beat: %f \t Beat Number: %f\n",currentbeat, beatnum); 
#endif
  newnoteobj (&yyvsp[-1]. t_note , yyvsp[0]. f , frogsi);
  /*$1.t_option = NULL;*/
  g_free(yyvsp[-1]. t_note .t_option);
  no_of_options = 0;
;
    break;}
case 29:
#line 398 "./frogparser.y"
{
  
  gint duration = 0;
  
  mudelaobject *newmudelaobj = NULL;
  if (currentbeat == beatnum && n == currentbar) 
    {
      totaldurs = beatnum;
    }
  else
    {
      beatnum = currentbeat;
    }
 

  duration = floattoduration (yyvsp[0]. f , is_tup);
#ifdef DEBUG
  printf("JTF Duration %f\t Denemo Duration: %d\n", yyvsp[0]. f ,duration);
  printf("Current beat: %f \t Beat Number: %f\n",currentbeat, beatnum); 
#endif
   
  frogsi->mode = INPUTREST; 
  newmudelaobj = newchord (duration, yyvsp[-1]. t_rest .dots);
 
  frogsi->currentmeasure->data = g_list_append
    ((objnode *)frogsi->currentmeasure->data,
     newmudelaobj);
  frogsi->currentobject = 
    g_list_last((objnode *)frogsi->currentmeasure->data);
  no_of_options = 0;
  /*g_free(newmudelaobj);*/

;
    break;}
case 31:
#line 435 "./frogparser.y"
{

  yyval. t_rest .rest = yyvsp[-1]. character ;
  yyval. t_rest .dots = yyvsp[0]. number ;

;
    break;}
case 32:
#line 443 "./frogparser.y"
{
  yyval. t_rest .rest = yyvsp[0]. character ;
  yyval. t_rest .dots = 0;
;
    break;}
case 33:
#line 451 "./frogparser.y"
{
  yyval. t_note .t_option = NULL;
  yyval. t_note .t_pitch = yyvsp[-3]. t_pitch ;
  strcpy (yyval. t_note .stemdir, yyvsp[-2]. string );
  yyval. t_note .t_option = yyvsp[-1]. t_option ;
  yyval. t_note .t_beamd = yyvsp[0]. t_beamd ;
  
  g_free(yyvsp[-1]. t_option );  
;
    break;}
case 34:
#line 464 "./frogparser.y"
{
  strcpy (yyval. t_pitch .notename, yyvsp[-1]. string );
  yyval. t_pitch .octave = yyvsp[0]. number ;

;
    break;}
case 35:
#line 471 "./frogparser.y"
{
  yyval. t_pitch .number_of_lines = yyvsp[0]. number ;
;
    break;}
case 36:
#line 478 "./frogparser.y"
{
  yyval. number  = yyvsp[0]. number ;
;
    break;}
case 37:
#line 485 "./frogparser.y"
{
  strcpy (yyval. string , yyvsp[0]. string );
;
    break;}
case 38:
#line 490 "./frogparser.y"
{
;
    break;}
case 39:
#line 496 "./frogparser.y"
{
  strcpy (yyval. string , yyvsp[0]. string );
;
    break;}
case 40:
#line 502 "./frogparser.y"
{
  yyval. t_option  = (struct p_noteoption *)g_malloc(sizeof( struct p_noteoption));
  yyval. t_option ->next = NULL;
  strcpy(yyval. t_option ->type, "\0");
  strcpy(yyval. t_option ->t_modifier.type, "\0");
  yyval. t_option ->t_modifier.dots = 0;
  
 /*g_free(item);*/
;
    break;}
case 41:
#line 512 "./frogparser.y"
{
  optionlist *nitem = createoption(yyvsp[-1]. t_modifier );
  strcpy(yyval. t_option ->type,yyvsp[-1]. t_modifier .type);
  
  insertoption(&yyval. t_option ,nitem);
  nitem = NULL;
  /*g_free(nitem);*/
;
    break;}
case 42:
#line 522 "./frogparser.y"
{  strcpy (yyval. t_modifier .type, yyvsp[0]. string ); ;
    break;}
case 43:
#line 523 "./frogparser.y"
{  strcpy (yyval. t_modifier .type, yyvsp[0]. string ); ;
    break;}
case 44:
#line 524 "./frogparser.y"
{ strcpy (yyval. t_modifier .type, yyvsp[0]. string );;
    break;}
case 45:
#line 525 "./frogparser.y"
{  
  strcpy(yyval. t_modifier .type,"dots");
  yyval. t_modifier .dots = yyvsp[0]. number ;
;
    break;}
case 46:
#line 529 "./frogparser.y"
{  strcpy (yyval. t_modifier .type, yyvsp[0]. string ); ;
    break;}
case 47:
#line 530 "./frogparser.y"
{  yyval. t_modifier .gracenote = yyvsp[0]. t_grace ; ;
    break;}
case 48:
#line 531 "./frogparser.y"
{  strcpy (yyval. t_modifier .type, yyvsp[0]. string ); ;
    break;}
case 49:
#line 532 "./frogparser.y"
{  strcpy (yyval. t_modifier .type, yyvsp[0]. string ); ;
    break;}
case 50:
#line 537 "./frogparser.y"
{
  strcpy (yyval. string , yyvsp[0]. string );

;
    break;}
case 51:
#line 543 "./frogparser.y"
{
  yyval. number  = yyvsp[0]. number ;

;
    break;}
case 52:
#line 551 "./frogparser.y"
{
  yyval. t_grace .t_pitch = yyvsp[-5]. t_pitch ;
  strcpy (yyval. t_grace .stemdir, yyvsp[-4]. string );
  yyval. t_grace .option = yyvsp[-3]. t_graceoption ;
  yyval. t_grace .t_beamd = yyvsp[-2]. t_beamd ;
  yyval. t_grace .duration = yyvsp[-1]. f ;
  yyval. t_grace .t_position = yyvsp[0]. t_position ;

;
    break;}
case 53:
#line 564 "./frogparser.y"
{
  strcpy (yyval. t_graceoption .type, yyvsp[-1]. string );
  yyval. t_graceoption .t_position = yyvsp[0]. t_position ;

;
    break;}
case 54:
#line 571 "./frogparser.y"
{
  strcpy (yyval. t_graceoption .type, yyvsp[-1]. string );
  yyval. t_graceoption .t_position = yyvsp[0]. t_position ;

;
    break;}
case 55:
#line 578 "./frogparser.y"
{
  strcpy (yyval. t_graceoption .type, yyvsp[-1]. string );
  yyval. t_graceoption .t_position = yyvsp[0]. t_position ;

;
    break;}
case 56:
#line 585 "./frogparser.y"
{
  yyval. t_graceoption .dots = yyvsp[-1]. number ;
  yyval. t_graceoption .t_position = yyvsp[0]. t_position ;
;
    break;}
case 57:
#line 591 "./frogparser.y"
{
  strcpy (yyval. t_graceoption .type, yyvsp[-1]. string );
  yyval. t_graceoption .t_position = yyvsp[0]. t_position ;

;
    break;}
case 58:
#line 598 "./frogparser.y"
{
  strcpy (yyval. t_graceoption .type, yyvsp[-1]. string );
  yyval. t_graceoption .t_position = yyvsp[0]. t_position ;
;
    break;}
case 59:
#line 606 "./frogparser.y"
{
  yyval. t_beamd .type = yyvsp[0]. t_beamtype ;
;
    break;}
case 60:
#line 611 "./frogparser.y"
{
  strcpy (yyval. t_beamd .direction, yyvsp[0]. string );
;
    break;}
case 61:
#line 616 "./frogparser.y"
{

;
    break;}
case 62:
#line 623 "./frogparser.y"
{
  strcpy (yyval. t_beamtype .btype, yyvsp[-1]. string );
  strcpy (yyval. t_beamtype .direction, yyvsp[0]. string );

;
    break;}
case 63:
#line 630 "./frogparser.y"
{
  strcpy (yyval. t_beamtype .btype, yyvsp[-1]. string );
  strcpy (yyval. t_beamtype .direction, yyvsp[0]. string );

;
    break;}
case 64:
#line 639 "./frogparser.y"
{

;
    break;}
case 65:
#line 646 "./frogparser.y"
{

;
    break;}
case 66:
#line 653 "./frogparser.y"
{

;
    break;}
case 67:
#line 660 "./frogparser.y"
{

  objnode *theobj = firstobjnode (frogsi->currentmeasure);
  mudelaobject *newmudelaobj = NULL;
  newmudelaobj = newtupopen (yyvsp[0]. t_tupops .numerator, yyvsp[0]. t_tupops .denominator);
  theobj = g_list_insert (theobj, newmudelaobj, counter);
  frogsi->cursor_x++;
  frogsi->currentmeasure->data = theobj;
  if (frogsi->cursor_appending)
    {
      frogsi->currentobject = g_list_last (theobj);
    }
  else
    {
      frogsi->currentobject = g_list_nth (theobj, frogsi->cursor_x);

    }
  is_tup = TRUE;
;
    break;}
case 68:
#line 681 "./frogparser.y"
{

  objnode *theobj = firstobjnode (frogsi->currentmeasure);
  mudelaobject *newmudelaobj = NULL;
  newmudelaobj = newtupclose ();
  theobj = g_list_insert (theobj, newmudelaobj, counter);
  frogsi->cursor_x++;
  frogsi->currentmeasure->data = theobj;
  if (frogsi->cursor_appending)
    {
      frogsi->currentobject = g_list_last (theobj);
    }
  else
    {
      frogsi->currentobject = g_list_nth (theobj, frogsi->cursor_x);

    }
  is_tup = FALSE;
;
    break;}
case 69:
#line 704 "./frogparser.y"
{
  yyval. t_tupops .numerator = yyvsp[-1]. number ;
  yyval. t_tupops .denominator = yyvsp[0]. number ;
;
    break;}
case 70:
#line 714 "./frogparser.y"
{
  strcpy (yyval. t_slur .string, yyvsp[-2]. string );
  yyval. t_slur .t_position = yyvsp[-1]. t_position ;
  strcpy (yyval. t_slur .curve, yyvsp[0]. string );


;
    break;}
case 71:
#line 723 "./frogparser.y"
{
  strcpy (yyval. t_hairpin .string, yyvsp[0]. string );
;
    break;}
case 73:
#line 728 "./frogparser.y"
{ ;
    break;}
case 74:
#line 729 "./frogparser.y"
{ newkeysigobj (yyvsp[0]. string ); ;
    break;}
case 75:
#line 732 "./frogparser.y"
{ ;
    break;}
case 76:
#line 735 "./frogparser.y"
{ ;
    break;}
case 77:
#line 738 "./frogparser.y"
{ ;
    break;}
case 78:
#line 739 "./frogparser.y"
{ ;
    break;}
case 79:
#line 742 "./frogparser.y"
{ ;
    break;}
case 80:
#line 743 "./frogparser.y"
{ ;
    break;}
case 84:
#line 749 "./frogparser.y"
{

;
    break;}
case 85:
#line 756 "./frogparser.y"
{

;
    break;}
case 86:
#line 763 "./frogparser.y"
{

;
    break;}
case 87:
#line 770 "./frogparser.y"
{
  yyval. number  = yyvsp[0]. number ;
;
    break;}
case 88:
#line 777 "./frogparser.y"
{
  yyval. number  = yyvsp[0]. number ;
;
    break;}
case 89:
#line 784 "./frogparser.y"
{
  yyval. number  = yyvsp[-2]. number ;
;
    break;}
case 90:
#line 789 "./frogparser.y"
{
  yyval. number  = yyvsp[0]. number ;
;
    break;}
case 91:
#line 796 "./frogparser.y"
{
  newtimesig (yyvsp[-2]. number , yyvsp[0]. number );
;
    break;}
case 92:
#line 801 "./frogparser.y"
{

;
    break;}
case 93:
#line 808 "./frogparser.y"
{

;
    break;}
case 94:
#line 815 "./frogparser.y"
{
  yyval. number  = yyvsp[0]. number ;
;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 821 "./frogparser.y"
int
froginput (char *filename, struct scoreinfo *si)
{
  extern FILE *yyin;
#ifdef YYDEBUG
  //  yydebug =1;
#endif
  if ((yyin = fopen (filename, "r")) == NULL)
    {
      fprintf (stderr, "Cannot open the file: %s\n", filename);
      return -1;
    }
  else
    {
      fprintf (stderr, "In FROGINPUT");
      yy_setscore (si);
      while (!feof (yyin))
	{
	  yyparse ();
	}
    }
  fclose (yyin);

  return 0;
}

int
yyerror (char *errmsg)
{
  extern char *yytext;

  fprintf (stderr, "%d : %s at default %s\n", errcount, errmsg, yytext);
  return 0;

}

/*
 * Add a new note to the bar takes p_note structure with all the data 
 * for the note to be inserted
 *
 */
void
newnoteobj (struct p_note *thenote, gfloat length, struct scoreinfo *si)
{
  gint no_dots=0;
  gchar notehead[20];
  objnode *theobj = firstobjnode (si->currentmeasure);
  mudelaobject *newmudelaobj = NULL;
  /*  struct p_modifier *mod = NULL;*/
  struct p_noteoption *list = 0;
  note *newnote = NULL;
  gint duration = 0, notename = 0, enharmonic = 0, i = 0;
  
  gboolean is_tie = FALSE;
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  notename =
    fetchnotename (thenote->t_pitch.notename, thenote->t_pitch.octave);
  enharmonic = fetchenharmonic (thenote->t_pitch.notename);
  
  
  for(list = thenote->t_option; list; list = list->next)
    {
      

      /*printf("Modifier = %s  :  %d  \n",list->t_modifier.type, 
	     list->t_modifier.dots);*/
      if (!strcmp (list->t_modifier.type, "tie"))
	is_tie = TRUE;
      if (list->t_modifier.dots)
	no_dots = list->t_modifier.dots;
      
      if (!strcmp (list->t_modifier.type, "cross")
	  || !strcmp (list->t_modifier.type, "diamond")
	  || !strcmp (list->t_modifier.type, "harmonic"))
	{
	  strcpy (notehead,list->t_modifier.type);
	}
      else
	strcpy (notehead,"normal");
    }
  
  if (beatnum != totaldurs)
    {
      duration = floattoduration (length, is_tup);
      newmudelaobj = newchord (duration, no_dots);
      
      ((chord *)newmudelaobj->object)->is_tied = is_tie;
      for(list = thenote->t_option; list; list = list->next)
	{
	  
	  
	  if (strcmp (list->t_modifier.type, "accent") == 0)
	    ((chord *)newmudelaobj->object)->is_accented_p = TRUE;
	  if (strcmp (list->t_modifier.type, "staccato") == 0)
	    ((chord *)newmudelaobj->object)->has_stacatto_p = TRUE;
	  if (strcmp (list->t_modifier.type, "fermata") == 0)
	    ((chord *)newmudelaobj->object)->has_fermata_p = TRUE;
	  if (strcmp (list->t_modifier.type, "tenuto") == 0)
	    ((chord *)newmudelaobj->object)->has_tenuto_p = TRUE;
	  if (strcmp (list->t_modifier.type, "trill") == 0)
	    ((chord *)newmudelaobj->object)->has_trill_p = TRUE;
	  if (strcmp (list->t_modifier.type, "turn") == 0)
	    ((chord *)newmudelaobj->object)->has_turn_p = TRUE;
	  if (strcmp (list->t_modifier.type, "mordent") == 0)
	    ((chord *)newmudelaobj->object)->has_mordent_p = TRUE;
	  if (strcmp (list->t_modifier.type, "staccatissimo") == 0)
	    ((chord *)newmudelaobj->object)->has_staccatissimo_p = TRUE;
	  if (strcmp (list->t_modifier.type, "ubow") == 0)
	    ((chord *)newmudelaobj->object)->has_ubow_p = TRUE;
	  if (strcmp (list->t_modifier.type, "dbow") == 0)	
	    ((chord *)newmudelaobj->object)->has_dbow_p = TRUE;
	}
      addtone (newmudelaobj, notename, enharmonic, cleftype);
      if(notehead)
	{
	  newnote = (note *)((chord *)newmudelaobj->object)->tones->data;
	  newnote->noteheadtype = setnoteheadtype (notehead);
	}
      theobj = g_list_insert (theobj, newmudelaobj, counter);
      si->cursor_x++;
      si->currentmeasure->data = theobj;
      if (si->cursor_appending)
	si->currentobject = g_list_last (theobj);
      else
	si->currentobject = g_list_nth (theobj, si->cursor_x);


    }
  else
    {

      addtone (curmudelaobj, notename, enharmonic, cleftype);
    }

  /* Should really do these two things once per measure, but anyway: */


  
}


static enum headtype
setnoteheadtype (gchar * type)
{
  if (strcmp (type, "cross") == 0)
    return DENEMO_CROSS_NOTEHEAD;
  else if (strcmp (type, "diamond") == 0)
    return DENEMO_DIAMOND_NOTEHEAD;
  else if (strcmp (type, "harmonic") == 0)
    return DENEMO_HARMONIC_NOTEHEAD;
  else
    return DENEMO_NORMAL_NOTEHEAD;
}

/*
 * Add new Clef at the beginning of the staff
 *
 */
static void
newclef (char *clefname)
{
  enum clefs clefstring;
  mudelaobject *clefobj;

  clefstring = cleftoenum (clefname);
  cleftype = clefstring;
  if (counter == 1)
    {
      ((staff *) frogsi->currentstaff->data)->sclef = clefstring;
      find_leftmost_staffcontext ((staff *)frogsi->currentstaff->data, frogsi);

    }
  else
    {

      clefobj = newclefobj (clefstring);
      frogsi->currentmeasure->data = g_list_append
	((objnode *)frogsi->currentmeasure->data, clefobj);

    }
}


/*
 * Add new Key Signature at the beginning of the staff
 *
 */
static void
newkeysigobj (char *keyname)
{
  mudelaobject *newobj = NULL;
  gboolean isminor = FALSE;
  gint keynum = 0;
  gint len = strlen (keyname);

  keynum = Keytoint (keyname);

  fprintf (stderr, "%d len \t %d keynum \n ", len, keynum);

  if (len == 4)
    {
      if (keyname[1] == 'm' && keyname[2] == 'i' && keyname[3] == 'n')
	{
	  if (counter == 2)
	    ((staff *) frogsi->currentstaff->data)->skey_isminor = TRUE;
	  else
	    isminor = TRUE;
	}
    }
  else if (len == 5)
    {
      if (keyname[2] == 'm' && keyname[3] == 'i' && keyname[4] == 'n')
	{
	  if (counter == 2)
	    ((staff *) frogsi->currentstaff->data)->skey_isminor = TRUE;
	  else
	    isminor = TRUE;

	}
    }
  if (counter == 2)
    {
      ((staff *) frogsi->currentstaff->data)->skey = keynum;
      find_leftmost_allcontexts (frogsi);
    }
  else
    {

      newobj = newkeyobj (keynum, isminor);
      frogsi->currentmeasure->data = g_list_append
	((objnode *)frogsi->currentmeasure->data, newobj);
    }
  initkeyaccs (((staff *) frogsi->currentstaff->data)->skeyaccs, keynum);
}

/*
 * Add new Time Signature at the beginning of the staff
 *
 */
static void
newtimesig (gint upper, gint lower)
{
  mudelaobject *ret;
  if (counter == 3)
    {
      ((staff *) frogsi->currentstaff->data)->stime1 = upper;
      ((staff *) frogsi->currentstaff->data)->stime2 = lower;
      find_leftmost_staffcontext ((staff *)frogsi->currentstaff->data, frogsi);
    }
  else
    {
      ret = newtimesigobj (upper, lower);
      frogsi->currentmeasure->data = g_list_append
	((objnode *)frogsi->currentmeasure->data, ret);
    }
}

static void
newdynamic (gchar * type)
{
  mudelaobject *ret;

  ret = dynamic_new (type);
  frogsi->currentmeasure->data = g_list_append
    ((objnode *)frogsi->currentmeasure->data, ret);
}


/* Set global Parser structure equal to the main scoreinfo structure */
void
yy_setscore (struct scoreinfo *si)
{
  frogsi = si;
  free_score (frogsi);
  frogsi->currentstaffnum = 0;

}


optionlist *createoption(struct p_modifier option)
{
  optionlist *newitem = (optionlist *)malloc(sizeof(optionlist));

  if(!newitem)
    return NULL;
  else {
    newitem->t_modifier = option;
    newitem->next = NULL;
  }
  return newitem;
}

void insertoption(optionlist **header, optionlist *newitem)
{
  newitem->next = *header;
  *header = newitem;

  return;
}


void emptylist(optionlist *head) 
{
  optionlist *itemdel = NULL;
  while(head != NULL) {
    itemdel = head;
    itemdel->next = NULL;
    free(itemdel);
    head = head->next;
   
  }
}
