/* headerdialog.cpp
 * Prompts the user to change the header information
 *
 *  (c) 2000, 2001, 2002  Laurent Martelli <laurent@linuxfan.com>
 * Modified by Matt Hiller 22 Apr 2000, 2001, 2002 
 */

#include <denemo/denemo.h> 
#include "utils.h"

struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *titleentry;
  GtkWidget *subtitleentry;
  GtkWidget *composerentry;
};

void
set_header (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = (struct callbackdata *)data;
  struct scoreinfo *si = cbdata->si;

  g_string_assign (si->title,
		   gtk_entry_get_text (GTK_ENTRY (cbdata->titleentry)));
  g_string_assign (si->subtitle,
		   gtk_entry_get_text (GTK_ENTRY (cbdata->subtitleentry)));
  g_string_assign (si->composer,
		   gtk_entry_get_text (GTK_ENTRY (cbdata->composerentry)));
}

/* Sorry Laurent - this was really out of whack with how any of the other
 * dialogs are written. I had to change it. */

void
header_change (gpointer callback_data, guint callback_action,
	       GtkWidget * widget)
{
  struct scoreinfo *si = (struct scoreinfo *)callback_data;
  static struct callbackdata cbdata;
  GtkWidget *dialog;
  GtkWidget *titleentry;
  GtkWidget *subtitleentry;
  GtkWidget *composerentry;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  GtkWidget *label;
  GtkWidget *table;
  if (si->lily_file)
    return;/* no code for this yet - just edit textually */
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Header Info"));

  table = gtk_table_new (3, 2, TRUE);

  label = gtk_label_new (_("Title:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  gtk_widget_show (label);
  titleentry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (titleentry), si->title->str);
  gtk_table_attach_defaults (GTK_TABLE (table), titleentry, 1, 2, 0, 1);
  gtk_widget_show (titleentry);

  label = gtk_label_new (_("Subtitle:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  gtk_widget_show (label);
  subtitleentry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (subtitleentry), si->subtitle->str);
  gtk_table_attach_defaults (GTK_TABLE (table), subtitleentry, 1, 2, 1, 2);
  gtk_widget_show (subtitleentry);

  label = gtk_label_new (_("Composer:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  composerentry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (composerentry), si->composer->str);
  gtk_table_attach_defaults (GTK_TABLE (table), composerentry, 1, 2, 2, 3);
  gtk_widget_show (composerentry);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      table, TRUE, TRUE, 0);
  gtk_widget_show (table);

  cbdata.si = si;
  cbdata.titleentry = titleentry;
  cbdata.subtitleentry = subtitleentry;
  cbdata.composerentry = composerentry;

  processenter (titleentry, set_header, cbdata, dialog);
  processenter (subtitleentry, set_header, cbdata, dialog);
  processenter (composerentry, set_header, cbdata, dialog);
  okbutton = gtk_button_new_with_label (_("OK"));

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      okbutton, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (set_header), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);


  gtk_widget_grab_focus (titleentry);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
}
