/* help.cpp
 * implements the stuff under Help in the menubar
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001, 2002 Matthew Hiller
 */

#include <denemo/denemo.h> 
#include "config.h"
#include <string.h> /* for strlen */
/* The tutorial mentioned that the actual gchar * held within a
 * GtkText widget needs to be freed.  I don't do such a free, though,
 * so I think this function has a memory leak in it. */

void
about (gpointer callback_data, guint callback_action, GtkWidget * widget)
{
  GtkWidget *dialog, *hbox, *text, *vscrollbar;
  static const gchar *about_text;
  about_text = g_strconcat
    (_("Denemo, the GNU graphical score editor\n\nVersion "),
     VERSION, "\n\n",
     _("(c) 1999, 2000, 2001 Matthew Hiller, Adam Tee, and others.\n\n\
http://www.gnu.org/software/denemo/denemo.html\n\n\
This program is licensed under the terms of the GNU\n\
General Public License and is provided with absolutely\n\
NO WARRANTY; see the file COPYING for details."), NULL);
#if GTK_MAJOR_VERSION > 1  
  GtkTextBuffer *buffer;
  GtkWidget *sw = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
                                  GTK_POLICY_AUTOMATIC,
                                  GTK_POLICY_AUTOMATIC);
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);/*window_new (GTK_WINDOW_DIALOG);*/
  gtk_window_set_title (GTK_WINDOW (dialog), _("About Denemo"));
  gtk_window_set_default_size (GTK_WINDOW (dialog), 500, 200);
  text = gtk_text_view_new ();
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text), FALSE);
  gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW (text), GTK_WRAP_WORD);
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text));
  gtk_text_buffer_set_text (buffer, about_text, -1);
  gtk_container_add (GTK_CONTAINER (dialog), sw);
  gtk_container_add (GTK_CONTAINER (sw), text);
  gtk_widget_show (text);
  gtk_widget_show (dialog);
#else
  dialog = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (dialog), _("About Denemo"));
  gtk_window_set_default_size (GTK_WINDOW (dialog), 500, 200);
  hbox = gtk_hbox_new (FALSE, 0);
  text = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (text), FALSE);
  gtk_text_set_word_wrap (GTK_TEXT (text), TRUE);
  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
  gtk_box_pack_end (GTK_BOX (hbox), vscrollbar, FALSE, FALSE, 0);
  gtk_widget_show (vscrollbar);

  gtk_text_set_point (GTK_TEXT (text), 0);
  gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, about_text, -1);
  gtk_box_pack_start (GTK_BOX (hbox), text, TRUE, TRUE, 0);
  gtk_widget_show (text);

  gtk_container_add (GTK_CONTAINER (dialog), hbox);
  gtk_widget_show (hbox);
  gtk_widget_show (dialog);
#endif
}
