/* midi.cpp
 * functions for direct output to /dev/sequencer
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001, 2002 Brian Delaney
 */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#ifdef HAVE_SYS_SOUNDCARD_H
#include <sys/soundcard.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <gtk/gtk.h>
#ifndef G_OS_WIN32
#include <sys/ioctl.h>
#endif
#include <denemo/denemo.h>
#include "draw.h"

#ifdef WITHALSA
extern "C" {
#include <alsa/asoundlib.h>
}
#define MAXCLIENTS 4

snd_seq_t *seq_handle = 0;
int my_client;
int my_port;
int queue;
int npfd;
struct pollfd *pfd;
void
midi_cleanup ()
{
  snd_seq_close(seq_handle);
}

gint
midi_init ()
{
  int res;
//d  int my_client;
  //int my_port;
  res = snd_seq_open(&seq_handle, "default", SND_SEQ_OPEN_OUTPUT, 0);
  snd_seq_set_client_name(seq_handle, "Denemo output");
  my_client = snd_seq_client_id(seq_handle);
  // create a new ALSA midi output
  my_port = snd_seq_create_simple_port(seq_handle, "Denemo",
				       SND_SEQ_PORT_CAP_SUBS_READ |
				       SND_SEQ_PORT_CAP_READ,
                                       SND_SEQ_PORT_TYPE_MIDI_GENERIC |
                                       SND_SEQ_PORT_TYPE_APPLICATION);
  if (my_port < 0) {
    perror("create output port");
    return -1;
  }

    
  queue = snd_seq_alloc_queue(seq_handle);
  if(queue < 0)
    fprintf(stderr, "Event output error: %s\n", snd_strerror(queue));  
  snd_seq_set_client_pool_output(seq_handle, 24);

  snd_seq_start_queue(seq_handle, queue, NULL);
  snd_seq_drain_output(seq_handle);
  //npfd = snd_seq_poll_descriptors_count(seq_handle, POLLOUT);
  //snd_seq_poll_descriptors(seq_handle, pfd, npfd, POLLOUT);
    
  return 0;
}
  
void
playnotes (gboolean doit, chord chord_to_play, int prognum)
{
  snd_seq_event_t *ev = (snd_seq_event_t *)g_new(snd_seq_event_t,1);
  snd_seq_event_t *ev1 = (snd_seq_event_t *)g_new(snd_seq_event_t,1);
  int err;
  snd_seq_addr_t addr;
  addr.client = my_client;
  addr.port = my_port;
  ev->dest = addr;
  ev->queue = queue;
  ev1->queue = queue;
  ev1->type = SND_SEQ_EVENT_PGMCHANGE;
  ev1->data.control.channel = 1;
  ev1->data.control.value = 40;
  snd_seq_ev_set_source(ev1, my_port);
  snd_seq_ev_set_subs(ev1);
  snd_seq_event_output_direct(seq_handle,ev1);
  ev->type = SND_SEQ_EVENT_NOTE;
  ev->data.note.channel = 1;
  ev->data.note.velocity = 100;
  ev->data.note.off_velocity = 0;
  ev->data.note.note = 60;
  ev->data.note.duration = 1000;
  snd_seq_ev_set_source(ev, my_port);
  snd_seq_ev_set_subs(ev);
  snd_seq_event_output_direct(seq_handle,ev);
  //ev1->dest = addr;
 // ev1->type = SND_SEQ_EVENT_NOTEOFF;
  //ev1->data.note.channel = 1;
  //ev1->data.note.velocity = 0;
  //ev1->data.note.note = 60;
  //ev1->data.note.duration = 100000;
  //snd_seq_ev_set_source(ev1, my_port);
  //snd_seq_ev_set_subs(ev1);
  //snd_seq_event_output_direct(seq_handle,ev1);

  snd_seq_free_event( ev );
  snd_seq_free_event( ev1 );

  
  
}
#else /*ALSA CODE*/
#define SEQ_DEV    "/dev/sequencer"
#define SEQ_DEV_N  0

#ifdef HAVE_SYS_SOUNDCARD_H
struct synth_info card_info;

SEQ_DEFINEBUF (128);
#endif

static int sequencer_fd = -1;
static gint ttag;
static gboolean shouldremove = FALSE;

void
midi_cleanup ()
{
  (void) close (sequencer_fd);
}

gint
midi_init ()
{
#ifdef HAVE_SYS_SOUNDCARD_H
  if ((sequencer_fd = open ("/dev/sequencer", O_WRONLY)) == -1)
    {
      perror (_("Error opening sequencer"));
      return -1;
    }

  card_info.device = 0;

  if (ioctl (sequencer_fd, SNDCTL_SYNTH_INFO, &card_info) == -1)
    {
      perror (_("Cannot get info on soundcard"));
      return -1;
    }

  printf (_("Synthesizer detected: %s\n"), card_info.name);
  printf (_("Synthesizer supports %d voices.\n"), card_info.nr_voices);

  /* Reset the sequencer */
  if (ioctl (sequencer_fd, SNDCTL_SEQ_RESET) == -1)
    {
      perror (_("Error resetting sequencer"));
      return -1;
    }

  SEQ_DUMPBUF ();
  close (sequencer_fd);
  sequencer_fd = -1;

#endif
  return 0;
}

#ifdef HAVE_SYS_SOUNDCARD_H

void
seqbuf_dump ()
{
  if (_seqbufptr)
    if (write (sequencer_fd, _seqbuf, _seqbufptr) == -1)
      {
	perror (_("Error during seqbuf_dump"));
	exit (-1);
      }
  _seqbufptr = 0;
}

static void
playtone (gpointer tone, gpointer chord, int prognum)
{
  gint offset;
  gchar key;
  gint voice;
  /* Because mid_c_offset is a measure of notes and we need a measure of
   * half-steps, this array will help */
  const gint key_offset[] = { -10, -8, -7, -5, -3, -1, 0, 2, 4, 5, 7, 9, 11 };

  offset = ((note *) tone)->mid_c_offset;

  /* 60 is middle-C in MIDI keys */
  key = 60 + 12 * (offset / 7) + key_offset[offset % 7 + 6];
  key += ((note *) tone)->enshift;
  voice = g_list_index ((GList *) chord, tone);

  SEQ_SET_PATCH (SEQ_DEV_N, voice, prognum);

  SEQ_START_NOTE (SEQ_DEV_N, voice, key, 127);
  SEQ_DUMPBUF ();
}

static void
stoptone (gpointer tone, gpointer chord)
{
  gint offset;
  gint voice;
  gchar key;
  /* Because mid_c_offset is a measure of notes and we need a measure of
   * half-steps, this array will help */
  const gint key_offset[] = { -10, -8, -7, -5, -3, -1, 0, 2, 4, 5, 7, 9, 11 };

  offset = ((note *) tone)->mid_c_offset;

  /* 60 is middle-C in MIDI keys */
  key = 60 + 12 * (offset / 7) + key_offset[offset % 7 + 6];
  key += ((note *) tone)->enshift;
  voice = g_list_index ((GList *) chord, tone);

  SEQ_STOP_NOTE (0, voice, key, 127);
  SEQ_DUMPBUF ();
}

#endif

static gint
close_seqfd (gpointer data)
{
  close (sequencer_fd);
  sequencer_fd = -1;
  shouldremove = FALSE;
  return FALSE;			/* Timeout function won't be called again */
}

/* This version of the function opens and closes /dev/sequencer w/ each
 * write, as a separate process for performance-type reasons */

void
playnotes (gboolean doit, chord chord_to_play, int prognum)
{

#ifdef HAVE_SYS_SOUNDCARD_H
  if (doit)
    if (sequencer_fd != -1
	|| (sequencer_fd = open ("/dev/sequencer", O_WRONLY)) != -1)
      {
	GList *tone;
	SEQ_START_TIMER ();
	/*
	g_list_foreach (chord_to_play.tones,
			(GFunc) playtone, chord_to_play.tones);
	*/
	tone = chord_to_play.tones;
	while(tone)
	  {
	    playtone(tone->data, chord_to_play.tones,prognum);
	    tone = tone->next;
	  }
	SEQ_DELTA_TIME (50);

	
	g_list_foreach (chord_to_play.tones,
			(GFunc) stoptone, chord_to_play.tones);
	if (shouldremove)
	  gtk_timeout_remove (ttag);
	ttag = gtk_timeout_add (1000, close_seqfd, NULL);
	/*shouldremove = TRUE;*/
      }
#endif
}

gint
playsong (struct scoreinfo *si)
{

  return 0;
}
#endif
