/* playbackprops.c
 * callback that creates a "Playback Properties" dialog box asking
 * the user to change the properties of the playback for the current 
 * score
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002 Adam Tee, Matthew Hiller */

#include <stdlib.h>
#include <string.h>
#include <denemo/denemo.h>
#include "utils.h"

struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *Tempoentry;
  GtkWidget *Startentry;
  GtkWidget *Endentry;
  GtkWidget *staffentry;
};


static void
set_playback (GtkWidget * widget, gpointer data)
{
  struct scoreinfo *si;
  gint n;
  struct callbackdata *cbdata = (struct callbackdata *)data;
  si = cbdata->si;

  if ((n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->Tempoentry)))))
    {
      si->tempo = n;
    }
  si->start = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->Startentry)));
  if (!si->start)
    gtk_entry_set_text (GTK_ENTRY (cbdata->Startentry), "0");
  si->end = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->Endentry)));
  if (!si->end)
    gtk_entry_set_text (GTK_ENTRY (cbdata->Endentry), "0");
  si->stafftoplay =
    atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->staffentry)));
  if (!si->stafftoplay)
    gtk_entry_set_text (GTK_ENTRY (cbdata->staffentry), "0");
}

void playback_properties_change
  (gpointer callback_data, guint callback_action, GtkWidget * widget)
{
  struct scoreinfo *si = (struct scoreinfo *)callback_data;
  static GtkWidget *dialog;
  static GtkWidget *label;
  static GtkWidget *table;
  static GtkWidget *Tempoentry;
  static GtkWidget *staffentry;
  static GtkWidget *Startentry;
  static GtkWidget *Endentry;
  static GtkWidget *okbutton;
  static GtkWidget *cancelbutton;
  static GString *entrycontent;
  static struct callbackdata cbdata;


  if (!entrycontent)
    {
      entrycontent = g_string_new (NULL);
    }
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Set playback properties"));

  table = gtk_table_new (2, 4, TRUE);

  label = gtk_label_new (_("Tempo"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  gtk_widget_show (label);
  Tempoentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", si->tempo);
  gtk_entry_set_text (GTK_ENTRY (Tempoentry), entrycontent->str);
  gtk_table_attach_defaults (GTK_TABLE (table), Tempoentry, 1, 2, 0, 1);
  gtk_widget_show (Tempoentry);

  label = gtk_label_new (_("Staff to Play (0 for all)"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  gtk_widget_show (label);
  staffentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", si->stafftoplay);
  gtk_entry_set_text (GTK_ENTRY (staffentry), entrycontent->str);
  gtk_table_attach_defaults (GTK_TABLE (table), staffentry, 1, 2, 1, 2);
  gtk_widget_show (staffentry);

  label = gtk_label_new (_("Start At Bar (0 for whole piece):"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 0, 1);
  gtk_widget_show (label);
  Startentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", si->start);
  gtk_entry_set_text (GTK_ENTRY (Startentry), entrycontent->str);
  gtk_table_attach_defaults (GTK_TABLE (table), Startentry, 3, 4, 0, 1);
  gtk_widget_show (Startentry);

  label = gtk_label_new (_("End At Bar (0 for whole piece):"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 1, 2);
  gtk_widget_show (label);
  Endentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", si->end);
  gtk_entry_set_text (GTK_ENTRY (Endentry), entrycontent->str);
  gtk_table_attach_defaults (GTK_TABLE (table), Endentry, 3, 4, 1, 2);
  gtk_widget_show (Endentry);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      table, TRUE, TRUE, 0);
  gtk_widget_show (table);

  /* Set up the callback data */
  cbdata.si = si;
  cbdata.Tempoentry = Tempoentry;
  cbdata.Startentry = Startentry;
  cbdata.Endentry = Endentry;
  cbdata.staffentry = staffentry;

  processenter (Tempoentry, set_playback, cbdata, dialog);
  processenter (Startentry, set_playback, cbdata, dialog);
  processenter (Endentry, set_playback, cbdata, dialog);
  processenter (staffentry, set_playback, cbdata, dialog);

  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      okbutton, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (set_playback), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);

  gtk_widget_grab_focus (Tempoentry);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_show (dialog);
}
