/* plugin.c 
 * 
 * Denemo plugin handler, uses gmodule
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2001, 2002 Adam Tee
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>

#include <denemo/denemo.h>
#include <denemo/denemo_version.h>
#include <glib.h>
#include <gmodule.h>
#include "plugin.h"


/*typedef void initialise (struct scoreinfo *si);*/


void 
load_plugin(gpointer callback_data, guint callback_action,GtkWidget *widget)
{
  g_print("In Load Plugin\n");
  struct scoreinfo *si = (struct scoreinfo *)callback_data;
  if(si)
    init_plugins(si);
  else
    g_print("Scoreinfo is 0x0");
  
}

/* List loaded plugins */
void 
list_plugins(gpointer callback_data, guint callback_action, GtkWidget *widget)
{
  GtkWidget *dialog;
  GtkWidget *clist;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  GList *tmp = NULL;
  gchar *item[1][2]; 
  gchar *titles[2] = {"Plugin", "Status"};

  struct scoreinfo *si = (struct scoreinfo *)callback_data;
  
  dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW (dialog), "Loaded Plugins");

  gtk_widget_set_usize(GTK_WIDGET(dialog), 250, 150);

  /* 
   * CList to show loaded plugins
   */
  clist = gtk_clist_new_with_titles(2, titles);
  gtk_clist_set_column_width(GTK_CLIST(clist), 0, 150);

  if(si->plugins) {
    for(tmp = si->plugins; tmp; tmp=tmp->next) {
      item[0][0] = (gchar *)((PluginData*)tmp->data)->title;
      item[0][1] = "Loaded";
      gtk_clist_append(GTK_CLIST(clist), item[0]);
    }
  }
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), clist, TRUE, TRUE,0);
  gtk_widget_show(clist);
  
  okbutton = gtk_button_new_with_label("OK");
  gtk_signal_connect_object(GTK_OBJECT(okbutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			    GTK_OBJECT(dialog));
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG(dialog)->action_area), okbutton,
		     TRUE, TRUE, 0);
  gtk_widget_show(okbutton);
  
  cancelbutton = gtk_button_new_with_label("Cancel");
  gtk_signal_connect_object(GTK_OBJECT(cancelbutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			    GTK_OBJECT(dialog));
  gtk_box_pack_start(GTK_BOX (GTK_DIALOG(dialog)->action_area), cancelbutton,
		     TRUE, TRUE, 0);
  gtk_widget_show(cancelbutton);
  
 
  gtk_signal_connect_object(GTK_OBJECT (dialog), "destroy",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			    GTK_OBJECT(dialog));
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_show(dialog);

  tmp = NULL;

}

void 
denemo_plugin_init(const gchar *name, struct scoreinfo *si)
{
  gchar *path;
  PluginData *data = NULL;
  /*initialise *init = NULL;*/
/*  void (*initialise)(struct scoreinfo *);
  GList *gl;*/

  data = (PluginData *)g_new0(PluginData, 1);
  
  if(!data) {
    g_print("allocation error");
    return;
  }
    
  path = g_module_build_path(PACKAGE_PLUGIN_DIR, name);
  path = g_strdup_printf("%s/lib%s.so.%d", PACKAGE_PLUGIN_DIR,name,
			 DENEMO_PLUGIN_API_MAJOR);

  data->handle = g_module_open(path, (GModuleFlags)0);

  if(!data->handle) 
    {
      fprintf(stderr, "Error opening %s: %s\n", path,
	      g_module_error());
      g_free(data);
      return;
    }
  bool foundsymbol = g_module_symbol( data->handle, "denemo_plugin_init", 
				     (gpointer *) &data->initialise);
 
  if(!foundsymbol) {
    g_warning ("Can't find symbol denemo_plugin_init in %s", path);
    g_module_close (data->handle);
    g_free(data);
  }
  g_print("Load Symbol\n");
  data->initialise(si, data);
 
  si->plugins = g_list_append(si->plugins, data);
  
}
/**
 * Should unload all loaded modules.
 *
 *
 */
void unloadplugins(gpointer callback_data, guint callback_action,
			  GtkWidget *widget)
{  
  GList *temp=NULL;
  struct scoreinfo *si = (struct scoreinfo *)callback_data;
  for(temp=si->plugins; temp; temp=temp->next) {
    PluginData *plugin = (PluginData *)temp->data;
    if(plugin) {
      plugin->clean_up(si,plugin);
      g_print("Unloading Plugin\n");
      si->plugins = g_list_remove(si->plugins, plugin);
      si->plugincounter--;
      g_module_close(plugin->handle);
      g_free(plugin);
    }
  }

}


/*
 * Stripname for matching plugins of form
 * lib(.*).so
 *
 */
static char *
stripname(char *d_name)
{
  int len, blen;
  char buf[8];

  if(strncmp(d_name, "lib", 3)) return 0;

  len = strlen(d_name);
  snprintf(buf, 8, ".so.%d", DENEMO_PLUGIN_API_MAJOR);
  blen = strlen(buf);
  
  if(strncmp(&d_name[len-blen], buf, blen)) return 0;

  d_name[len-blen] = '\0';

  return &d_name[3];
}


static void 
init_dynamic_plugins_dir(gchar *dirname, struct scoreinfo *si)
{
  DIR *dir;
  struct dirent *dirent;
  char *name;

  dir = opendir(dirname);
  if(!dir)
    return ;

  while((dirent = readdir(dir)) != NULL)
    {
      if((name = stripname(dirent->d_name)) != NULL)
	denemo_plugin_init(name, si);
    }
}


static void
init_dynamic_plugins(struct scoreinfo *si)
{
  init_dynamic_plugins_dir(PACKAGE_PLUGIN_DIR, si);
}


void
init_plugins(struct scoreinfo *si)
{
  printf("Initialising plugins\n");
  if(g_module_supported())
    init_dynamic_plugins(si);

}
  
