/* tupletops.cpp  
 * Set Tuplet options 
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001, 2002 Adam Tee Matthew Hiller
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "tupletops.h"
#include "chordops.h"
#include "contexts.h"
#include <denemo/denemo.h>
#include "staffops.h"
#include "utils.h"
#include "draw.h"
#include "measureops.h"
#include "midi.h"
#include "objops.h"
#include "commandfuncs.h"

mudelaobject *
newtupopen (gint numerator, gint denominator)
{
  mudelaobject *tuplet;
  tupopen *newtup = (tupopen *)g_malloc (sizeof (tupopen));
  tuplet = (mudelaobject *)g_malloc (sizeof (mudelaobject));
  tuplet->type = TUPOPEN;
  newtup->numerator = numerator;
  newtup->denominator = denominator;

  tuplet->object = newtup;
  set_basic_numticks (tuplet);
  setpixelmin (tuplet);
  return tuplet;
}

mudelaobject *
newtupclose ()
{
  mudelaobject *tuplet;

  tuplet = (mudelaobject *)g_malloc (sizeof (mudelaobject));
  tuplet->type = TUPCLOSE;
  set_basic_numticks (tuplet);
  setpixelmin (tuplet);
  return tuplet;
}

struct callbackdata
{
  GtkWidget *numerator;
  GtkWidget *denominator;
  GtkWidget *scorearea;
  mudelaobject *theobj;
}
 ;

void
set_tupval (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = (struct callbackdata *) data;
  mudelaobject *theobj = cbdata->theobj;

  ((tupopen *)theobj->object)->numerator =
    atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->numerator)));
  ((tupopen *)theobj->object)->denominator =
    atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->denominator)));
  gtk_widget_draw (cbdata->scorearea, NULL);
}

/* This is broken at the moment because the program doesn't pause
 * when the dialog is created. Fix me. */

void
tupletchangedialog (mudelaobject * theobj, GtkWidget * scorearea)
{

  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *numerator;
  GtkWidget *denominator;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  static struct callbackdata cbdata;
  GString *entrycontent = NULL;

  dialog = gtk_dialog_new ();
  if (!entrycontent)
    entrycontent = g_string_new (NULL);
  gtk_window_set_title (GTK_WINDOW (dialog),
			_("Customize tuplet multiplier"));

  label = gtk_label_new (_("Numerator"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  numerator = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", 
		    ((tupopen *)theobj->object)->numerator);
  gtk_entry_set_text (GTK_ENTRY (numerator), entrycontent->str);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      numerator, TRUE, TRUE, 0);
  gtk_widget_show (numerator);

  label = gtk_label_new (_("Denominator"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  denominator = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", 
		    ((tupopen *)theobj->object)->denominator);
  gtk_entry_set_text (GTK_ENTRY (denominator), entrycontent->str);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      denominator, TRUE, TRUE, 0);
  gtk_widget_show (denominator);

  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      okbutton, TRUE, TRUE, 0);
  cbdata.numerator = numerator;
  cbdata.denominator = denominator;
  cbdata.scorearea = scorearea;
  cbdata.theobj = theobj;

  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (set_tupval), &cbdata);

  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);
  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);

  gtk_widget_grab_focus (numerator);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
}
