/* view.cpp
 * Functions to create a new view of the main window
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2003  Adam Tee
 */
#include "view.h"
#include "lyparserfuncs.h"

#if GTK_MAJOR_VERSION > 1
#include <gtk/gtkaccelgroup.h>
#endif

#define INITIAL_WIDTH 1100
#define INITIAL_HEIGHT 500

extern GList *displays;
/* when invoked (via signal delete_event or file->quit), terminates
 * the application.  */

void
closeit (GtkWidget * widget, gpointer data)
{
 
  gtk_main_quit ();
}

void
close_application (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  struct scoreinfo *si = (struct scoreinfo *)data;
  if (si->haschanged)
    {
  confirmbox (si, GTK_SIGNAL_FUNC (closeit));
    }
  else
    {
      closeit (widget, data);
    }
}
void
closewrapper (gpointer data, guint callback_action, GtkWidget * widget)
{
  GList *tmp=NULL;
  struct scoreinfo *si;
  if(g_list_length(displays) > 1) {
    for(tmp=displays; tmp && g_list_length(tmp) > 1; tmp=tmp->next) {
      si = (struct scoreinfo *)tmp->data;
      if (si->haschanged)
	{
	  confirmbox (si, GTK_SIGNAL_FUNC (close_view));
	}
      else
	{
	  close_view (widget, data);
	}
    }
  }
  si = (struct scoreinfo *)data;
  if (si->haschanged)
    {
      confirmbox((struct scoreinfo *) data, GTK_SIGNAL_FUNC (closeit));
    }
  else
    {
      closeit (widget, data);
    }
}

void createview(gpointer data, guint callback_action, GtkWidget *widget)
{
  newview();
}

void openinnew(gpointer data, guint callback_action, GtkWidget *widget)
{  
  struct scoreinfo *si =(struct scoreinfo *)g_list_last(displays)->data;
  newview();
  if (si->haschanged)
    {
      confirmbox(si, GTK_SIGNAL_FUNC (file_open));
    }
  else
    {      
      file_open (NULL, si);
    }
}

void close_view( GtkWidget *widget, gpointer data)
{
  displays = g_list_remove(displays,data);
  gtk_widget_destroy(((struct scoreinfo *)data)->window);
  g_free((struct scoreinfo *)data);
}

void closeview(gpointer data, guint callback_action, GtkWidget *widget)
{
  struct scoreinfo *si = (struct scoreinfo *)data;
  if(g_list_length(displays) == 1)
  if (si->haschanged)
    {
    confirmbox(si,GTK_SIGNAL_FUNC(closeit));
    }
  else
    {
      closeit (widget, data);
    }
  else
    if (si->haschanged)
      {
	confirmbox(si,GTK_SIGNAL_FUNC(close_view)); 
      }
    else
      {
	close_view (widget, data);
      }
}


GtkItemFactoryEntry menu_items[] = {
  {N_("/_File"), "<control>a", NULL, 0, "<Branch>"},
  {N_("/File/"), "<control>b", NULL, 0, "<Tearoff>"},
  {N_("/File/_New"), NULL, GTK_SIGNAL_FUNC(file_newwrapper), 0, NULL},
  {N_("/File/New _Window"), NULL, GTK_SIGNAL_FUNC(createview),0, NULL},
  {N_("/File/_Open"), NULL, GTK_SIGNAL_FUNC(file_openwrapper), 0, NULL},
  {N_("/File/Open in New Window"), NULL, GTK_SIGNAL_FUNC(openinnew),0,NULL},
  {N_("/File/_Save"), NULL, GTK_SIGNAL_FUNC(file_savewrapper), 0, NULL},
  {N_("/File/Save _As"), NULL, GTK_SIGNAL_FUNC(file_saveaswrapper), 0, NULL},
  {N_("/File/sep1"), NULL, NULL, 0, "<Separator>"},
  {N_("/File/Set _Headers"), NULL, GTK_SIGNAL_FUNC(header_change), 0, NULL},
  {N_("/File/sep3"), NULL, NULL, 0, "<Separator>"},
  {N_("/File/_Print"), NULL, GTK_SIGNAL_FUNC(print), 0, NULL},
  {N_("/File/_Close"), NULL,GTK_SIGNAL_FUNC(closeview), 0, NULL},
  {N_("/File/_Quit"), NULL, GTK_SIGNAL_FUNC(closewrapper), 0, NULL},
  {N_("/_Edit"), NULL, NULL, 0, "<Branch>"},
  {N_("/Edit/"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Edit/_Copy"), NULL, GTK_SIGNAL_FUNC(copywrapper), 0, NULL},
  {N_("/Edit/C_ut"), NULL, GTK_SIGNAL_FUNC(cutwrapper), 0, NULL},
  {N_("/Edit/_Paste"), NULL, GTK_SIGNAL_FUNC(pastewrapper), 0, NULL},
  {N_("/Edit/Save Selection"), NULL, GTK_SIGNAL_FUNC(saveselwrapper), 0, NULL},
  {N_("/Edit/sep1"), NULL, NULL, 0, "<Separator>"},
  {N_("/Edit/P_references"), NULL, GTK_SIGNAL_FUNC(preferences_change), 0, 
   NULL},
  {N_("/Edit/_Keyboard"), NULL, GTK_SIGNAL_FUNC(configure_keyboard_dialog), 0,
   NULL},
  {N_("/Edit/Load Plugins"), NULL, GTK_SIGNAL_FUNC(load_plugin), 0, NULL},
  {N_("/Edit/Unload Plugins"), NULL, GTK_SIGNAL_FUNC(unloadplugins),0, NULL},
  {N_("/Edit/List Plugins"), NULL, GTK_SIGNAL_FUNC(list_plugins), 0, NULL},
  {N_("/_Staff"), NULL, NULL, 0, "<Branch>"},
  {N_("/Staff/"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Staff/Add New Staff _Before Current Staff"), NULL, 
   GTK_SIGNAL_FUNC(newstaff), BEFORE, NULL},
  {N_("/Staff/Add New Staff _After Current Staff"), NULL, 
   GTK_SIGNAL_FUNC(newstaff), AFTER, NULL},
  {N_("/Staff/Add New Staff in _Initial Position"), NULL, 
   GTK_SIGNAL_FUNC(newstaff), FIRST, NULL},
  {N_("/Staff/Add New Staff in _Last Position"), NULL, 
   GTK_SIGNAL_FUNC(newstaff), LAST, NULL},
  {N_("/Staff/sep1"), NULL, NULL, 0, "<Separator>"},
  {N_("/Staff/Add _Voice to Current Staff"), NULL,
   GTK_SIGNAL_FUNC(newstaff), NEWVOICE, NULL},
  {N_("/Staff/Add Lyric Staff"), NULL, GTK_SIGNAL_FUNC(newstaff),
   LYRICSTAFF, NULL},
  {N_("/Staff/Add Figured Bass Staff"), NULL, GTK_SIGNAL_FUNC(newstaff), 
   FIGURESTAFF, NULL},
  {N_("/Staff/sep2"), NULL, NULL, 0, "<Separator>"},
  {N_("/Staff/Staff _Properties"), NULL, 
   GTK_SIGNAL_FUNC(staff_properties_change), 0, NULL},
  {N_("/_Clef"), NULL, NULL, 0, "<Branch>"},
  {N_("/Clef/"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Clef/Set _Initial Clef"), NULL, GTK_SIGNAL_FUNC(clef_change), 
   CHANGEINITIAL, NULL},
  {N_("/Clef/Insert Clef _Change"), NULL, GTK_SIGNAL_FUNC(clef_change), 
   INSERT, NULL},
  {N_("/_Key"), NULL, NULL, 0, "<Branch>"},
  {N_("/Key/"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Key/Set _Initial Key Signature"), NULL,
   GTK_SIGNAL_FUNC(key_change), CHANGEINITIAL, NULL},
  {N_("/Key/Insert Key Signature _Change"), NULL, GTK_SIGNAL_FUNC(key_change),
   INSERT, NULL},
  {N_("/_Time"), NULL, NULL, 0, "<Branch>"},
  {N_("/Time/"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Time/Set _Initial Time Signature"), NULL,
   GTK_SIGNAL_FUNC(timesig_change), CHANGEINITIAL, NULL},
  {N_("/Time/Insert Time Signature _Change"), NULL,
   GTK_SIGNAL_FUNC(timesig_change), INSERT, NULL},
  {N_("/_Other"), NULL, NULL, 0, "<Branch>"},
  {N_("/Other/"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Other/Change _Notehead"), NULL, 
   GTK_SIGNAL_FUNC(set_notehead), 0, NULL},
  {N_("/Other/Insert _Stemming Directive"), NULL, 
   GTK_SIGNAL_FUNC(stem_directive_insert), 0, NULL},
  {N_("/Other/Insert _Lyric"), NULL, GTK_SIGNAL_FUNC(lyric_insert),0, NULL},
  {N_("/Other/Edit Lyric"), NULL, GTK_SIGNAL_FUNC(lyric_insert),0,NULL},
  {N_("/Other/Edit _FiguredBass"), NULL, GTK_SIGNAL_FUNC(figure_insert),
   0, NULL},
  {N_("/Other/Insert _Dynamic"), NULL, 
   GTK_SIGNAL_FUNC(insert_dynamic), 0, NULL},
  {N_("/Other/Insert Lily Directive"), NULL, GTK_SIGNAL_FUNC(lily_directive),
   0,NULL},
  {N_("/Other/Insert _Articulation"), NULL, NULL, 0, "<Branch>"},
  {N_("/Other/Insert _Articulation/General"), NULL, 
   GTK_SIGNAL_FUNC(insert_articulation), GENERAL, NULL},
  {N_("/Other/Insert _Articulation/String"), NULL, 
   GTK_SIGNAL_FUNC(insert_articulation), STRING, NULL},
  {N_("/Other/Insert _Articulation/Organ"), NULL, 
   GTK_SIGNAL_FUNC(insert_articulation), ORGAN, NULL},
  {N_("/Other/Insert_Barline"), NULL, GTK_SIGNAL_FUNC(insert_barline), 
   0, NULL},
  {N_("/_Display"), NULL, NULL, 0, "<Branch>"},
  {N_("/Display/"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/_Display/Change _Measure Width"), NULL, 
   GTK_SIGNAL_FUNC(score_mwidth_change), 0, NULL},
  {N_("/_Display/Change _Space between Staffs"), NULL,
   GTK_SIGNAL_FUNC(score_staffspace_change), 0, NULL},
  {N_("/_Navigation"), NULL, NULL, 0, "<Branch>"},
  {N_("/Navigation/"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Navigation/Go _To Measure"), NULL, GTK_SIGNAL_FUNC(tomeasurenum), 
   0, NULL},
  {N_("/Navigation/To _Beginning of Score"), NULL, GTK_SIGNAL_FUNC(tohome), 
   0, NULL},
  {N_("/Navigation/To _End of Score"), NULL, GTK_SIGNAL_FUNC(toend), 0, NULL},
  {N_("/Navigation/To _Next Score"), NULL, GTK_SIGNAL_FUNC (tonextscore),
   0, NULL},
  {N_("/_Playback"), NULL, NULL, 0, "<Branch>"},
  {N_("/Playback/"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Playback/_Play"), NULL, GTK_SIGNAL_FUNC(playback), 0, NULL},
  {N_("/Playback/Play_CSound"), NULL, GTK_SIGNAL_FUNC(csoundplayback),0,NULL},
  {N_("/Playback/P_roperties"), NULL, 
   GTK_SIGNAL_FUNC(playback_properties_change), 0, NULL},
  {N_("/_Help"), NULL, NULL, 0, "<LastBranch>"},
  {N_("/Help/"), NULL, NULL, 0, "<Tearoff>"},
  /*  {N_("/Help/List _Keybindings"), NULL, keybindings, 0, NULL}, */
  {N_("/_Help/_About"), NULL, GTK_SIGNAL_FUNC(about), 0, NULL}
};

gint n_menu_items = (sizeof (menu_items) / sizeof (GtkItemFactoryEntry));

void newview()
{
  struct scoreinfo *si = 
    (struct scoreinfo *)g_malloc (sizeof (struct scoreinfo));
  struct prefinfo *prefs;
  GtkWidget *main_vbox, *menubar, *score_and_scroll_hbox;
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  /* Initialize preferences */
  prefs = initprefs ();
  /* Initialize the staff structure */
  init_score (si);
  si->prefs = prefs;
  newstaff (si, INITIAL, NULL);
  si->pixmap = NULL;

  /* Initialize the GUI */

  si->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
#if GTK_MAJOR_VERSION > 1
  /*  default  gtk_window_set_policy() is better for showing the text window */
#else
  gtk_window_set_policy (GTK_WINDOW (si->window), TRUE, TRUE, FALSE);
#endif
  main_vbox = gtk_vbox_new (FALSE, 1);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 1);
  gtk_container_add (GTK_CONTAINER (si->window), main_vbox);
  gtk_widget_show (main_vbox);

  /* This part is taken more-or-less directly from the gtk+ tutorial */
  accel_group = gtk_accel_group_new ();
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				       accel_group);
  gtk_item_factory_create_items (item_factory, n_menu_items, menu_items, si);
  /* This also sets si as the  callback data for all the functions in the 
   * menubar, which is precisely what we want. */
#if GTK_MAJOR_VERSION > 1
  /* this is very suspicious - a leading underscore shouldn't appear in this code surely */
  _gtk_accel_group_attach (accel_group, (GObject*)GTK_OBJECT (si->window));
#else
  gtk_accel_group_attach (accel_group, GTK_OBJECT (si->window));
#endif
  menubar = gtk_item_factory_get_widget (item_factory, "<main>");
  si->menubar = menubar;
  gtk_box_pack_start (GTK_BOX (main_vbox), menubar, FALSE, TRUE, 0);
  gtk_widget_show (menubar);

  score_and_scroll_hbox = gtk_hbox_new (FALSE, 1);
  gtk_box_pack_start (GTK_BOX (main_vbox), score_and_scroll_hbox, TRUE, TRUE,
		      0);
  gtk_widget_show (score_and_scroll_hbox);

  si->scorearea = gtk_drawing_area_new ();
#if GTK_MAJOR_VERSION > 1
  gtk_window_set_default_size (GTK_WINDOW(si->window), INITIAL_WIDTH, INITIAL_HEIGHT);
#else
  gtk_drawing_area_size (GTK_DRAWING_AREA (si->scorearea),
			 INITIAL_WIDTH, INITIAL_HEIGHT);
#endif
  gtk_box_pack_start (GTK_BOX (score_and_scroll_hbox), si->scorearea, TRUE,
		      TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (si->scorearea), "expose_event",
		      GTK_SIGNAL_FUNC (scorearea_expose_event), si);
  gtk_signal_connect (GTK_OBJECT (si->scorearea), "configure_event",
		      GTK_SIGNAL_FUNC (scorearea_configure_event), si);
  gtk_signal_connect (GTK_OBJECT (si->scorearea), "button_release_event",
		      GTK_SIGNAL_FUNC (scorearea_button_release), si);
  gtk_widget_set_events (si->scorearea, (GDK_EXPOSURE_MASK
					 | GDK_LEAVE_NOTIFY_MASK
					 | GDK_BUTTON_PRESS_MASK
					 | GDK_BUTTON_RELEASE_MASK));
  gtk_widget_show (si->scorearea);

  si->vadjustment = gtk_adjustment_new (1.0, 1.0, 2.0, 1.0, 4.0, 1.0);
  gtk_signal_connect (GTK_OBJECT (si->vadjustment), "value_changed",
		      GTK_SIGNAL_FUNC (vertical_scroll), si);
  si->vscrollbar = gtk_vscrollbar_new (GTK_ADJUSTMENT (si->vadjustment));
  gtk_box_pack_start (GTK_BOX (score_and_scroll_hbox), si->vscrollbar, FALSE,
		      TRUE, 0);
  gtk_widget_show (si->vscrollbar);

  si->hadjustment = gtk_adjustment_new (1.0, 1.0, 2.0, 1.0, 4.0, 1.0);
  gtk_signal_connect (GTK_OBJECT (si->hadjustment), "value_changed",
		      GTK_SIGNAL_FUNC (horizontal_scroll), si);
  si->hscrollbar = gtk_hscrollbar_new (GTK_ADJUSTMENT (si->hadjustment));
  gtk_box_pack_start (GTK_BOX (main_vbox), si->hscrollbar, FALSE, TRUE, 0);
  gtk_widget_show (si->hscrollbar);

  gtk_signal_connect (GTK_OBJECT (si->window), "delete_event",
		      (GtkSignalFunc) close_application, si);
  gtk_signal_connect (GTK_OBJECT (si->window), "key_press_event",
		      (GtkSignalFunc) scorearea_keypress_event, si);

  gtk_widget_show (si->window);

  /* Now that the window's shown, initialize the gcs */
  gcs_init (si->window->window);
  
  /* Similarly, the keymap should be initialized after the
     only once si->window is shown, as it may pop up an advisory
     dialog. */
  si->prefs->the_keymap = init_keymap ();
  displays = g_list_append(displays,si);
  g_print("No of Displays %d\n", g_list_length(displays));
}
  
