/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "global.h"
#include "windowposition.h"
#include "positiontext.h"
#include "iwc.h"
#include <stdlib.h>

void SetValidHints(XSizeHints *hint)
{
  int x,y;
  unsigned int width,height;
  unsigned int border,depth;
  Window root; 
  div_t p;

  XGetGeometry(GetDisplay(),XDefaultRootWindow(GetDisplay()),&root,&x,&y,&width,&height,&border,&depth);
  if ((hint->x+hint->width/2)<0 ||
      (hint->x+hint->width/2)>width ||
      (hint->y+hint->height/2)<0 ||
      (hint->y+hint->height/2)>height) {
    hint->x=hint->x+hint->width/2;
    hint->y=hint->y+hint->height/2;
    p=div(hint->x,width);
    if (hint->x<0)
      hint->x=hint->x-(p.quot-1)*width;
    else
      hint->x=p.rem;
    p=div(hint->y,height);
    if (hint->y<0)
      hint->y=hint->y-(p.quot-1)*height;
    else
      hint->y=p.rem;
    hint->x=hint->x-hint->width/2;
    hint->y=hint->y-hint->height/2;
  }
}

int SaveNewWindowPosition()
{
  char *pos1;
  char *pos2;
  char *pos3;
  char *dummy1,*dummy2;
  XWindowAttributes rootatr;
  int x=0,y=0;
  unsigned int width=0,height=0;
  unsigned int border,depth;
  Window root;
  Window follow;
  XEvent ev;
  do {
    if (XEventsQueued(GetDisplay(),QueuedAfterReading)>0) {
      XPeekEvent(GetDisplay(),&ev);
      if (ev.type==ConfigureNotify || ev.type==NoExpose)
        XNextEvent(GetDisplay(),&ev);
    }
  } while(XEventsQueued(GetDisplay(),QueuedAfterReading)>0 && (ev.type==ConfigureNotify || ev.type==NoExpose));
  follow=GetWindow();
  XGetWindowAttributes(GetDisplay(),GetWindow(),&rootatr);
  if (rootatr.x==0 && rootatr.y==0)
    follow=GetParent(follow);
  follow=GetParent(follow);
  XGetGeometry(GetDisplay(),follow,
              &root,&x,&y,&width,&height,&border,&depth);

  if (rootatr.map_state!=IsUnmapped) {
    GetFileInfoFromDesktop(GetWindowName(),&pos3,&dummy1,&dummy2);
    if (pos3==NULL)
      SetPositionToText(&pos1,x,y,' ');
    else
      SetPositionToText(&pos1,x,y,pos3[0]);
    SetPositionToText(&pos2,rootatr.width,rootatr.height,' ');
    SendFileInfoToDesktop(GetWindowName(),pos1,NULL,pos2);
    free(pos1);
    free(pos2);
    free(pos3);
    free(dummy1);
    free(dummy2);
    return True; /*calcmovewindowsize nessesary*/
  } else
    return False;
}

