#!/usr/bin/perl -w

# Copyright (c) 1998 by Marco Budde (Budde@tu-harburg.de)
# GNU General Public License

##############################################################
#   sgmltools -> dhelp, dwww, index.html                     #
#                                                            # 
#       usage:  sgml2dhelp <dhelp section> <dwww section>    #
##############################################################

# you
$maintainer = 'Marco Budde (Budde@tu-harburg.de)';

# regexp to find the root html file of a document
$file_expr = '^(.+)[^0-9]\.html$';

# regexp to produce a link name from the file name
$title_expr = '^(.+)\.html$';


##############################
#  get abstract of document  #
##############################

sub get_abstract
{
  my $zw;

  open (IN, "< $filename") or die "can't open $filename!\n";
  $abstract = '';
  while ($zw = <IN>)
  {
    if ($zw =~ /<P><HR><EM>(.*)/)
    {
      $abstract = $1;
      while ($zw !~ /<\/EM><HR><\/P>/)
      {
        $zw = <IN>;
        $abstract .= ' ' . $zw;
      } 
    }
  }
  $abstract =~ s/<\/EM><HR><\/P>//;
  close (IN);
}


##################
#  write .dhelp  #
##################

sub write_dhelp
{
  print DHELP "<item>\n";
  print DHELP "<directory>$ARGV[0]\n";
  print DHELP "<linkname>$linkname\n";
  print DHELP "<filename>$filename\n";
  print DHELP "<description>\n$abstract\n</description>\n";
  print DHELP "</item>\n\n";  
}


#########################
#  .dwww-index support  #
#########################

sub dwww_pwd
{
  $pwd = `pwd`;
  $pwd =~ /.*?\/usr\/doc\/*(.*)/;
  $pwd = $1;
}

sub write_dwww
{
  print DWWW "#section $ARGV[1]\n";
  print DWWW "<dt><a href=\"$pwd/$filename\">$linkname</a>\n";
  print DWWW "<dd>$abstract\n\n";
}

########################
#  index.html support  #
########################

sub write_index
{
  print INDEX "<DT><A HREF=\"$filename\">$linkname</A>\n";
  print INDEX "<DD>$abstract\n\n";
}


################
#     main     #
################

opendir (DIRHANDLE, '.');
@dircontent = readdir (DIRHANDLE);
closedir (DIRHANDLE);

open (DHELP, "> .dhelp");
open (INDEX, "> index.html");
print INDEX "<HTML>\n<BODY>\n<DL>\n";
open (DWWW, "> .dwww-index");
&dwww_pwd;

foreach $filename (sort @dircontent)
{
  if ($filename =~ /$file_expr/)
  {
    $filename =~ /$title_expr/;
    $linkname = $1;
    print "$filename\n";
    &get_abstract;
    &write_dhelp;
    &write_index;
    &write_dwww;
  }
}

close (DHELP);
print INDEX "</DL>\n<HR>\n<ADDRESS><SMALL>\n";
print INDEX "Please send comments to $maintainer.\n";
$time = gmtime (time);
print INDEX "<BR>This page was created $time GMT.</SMALL></ADDRESS>\n";
print INDEX "</BODY>\n</HTML>\n";
close (INDEX);
close (DWWW);

