## ------------------------
## Python file handling
## From Andrew Dalke
## Updated by James Henstridge
## Hacked by Arjan Molenaar for Python2.2 usage
## ------------------------

# AM_PATH_PYTHON

# Adds support for distributing Python modules and packages.  To
# install modules, copy them to $(pythondir), using the python_PYTHON
# automake variable.  To install a package with the same name as the
# automake package, install to $(pkgpythondir), or use the
# pkgpython_PYTHON automake variable.

# The variables $(pyexecdir) and $(pkgpyexecdir) are provided as
# locations to install python extension modules (shared libraries).
# Another macro is required to find the appropriate flags to compile
# extension modules.

# If your package is configured with a different prefix to python,
# users will have to add the install directory to the PYTHONPATH
# environment variable, or create a .pth file (see the python
# documentation for details).

# If the MINIUMUM-VERSION argument is passed, AM_PATH_PYTHON will
# cause an error if the version of python installed on the system
# doesn't meet the requirement.  MINIMUM-VERSION should consist of
# numbers and dots only.


AC_DEFUN([AM_PATH_PYTHON],
 [
  dnl Find a version of Python.  I could check for python versions 1.4
  dnl or earlier, but the default installation locations changed from
  dnl $prefix/lib/site-python in 1.4 to $prefix/lib/python1.5/site-packages
  dnl in 1.5, and I don't want to maintain that logic.

  AC_ARG_WITH(python, [  --with-python=PATH path to python interpreter ])

  if test "x$with_python" = "x"; then
    AC_PATH_PROGS(PYTHON, python2.3 python2.2 python2 python)
  else
    PYTHON="$with_python"
    AC_SUBST(PYTHON)
  fi

  dnl should we do the version check?
  AC_MSG_CHECKING(if Python version >= 2.2)
  changequote(<<, >>)dnl
  prog="
import sys #, string
minver = (2, 2)
#pyver = sys.version_info
# split strings by '.' and convert to numeric
#minver = map(string.atoi, string.split(minver, '.'))
pyver = sys.version_info # map(string.atoi, string.split(pyver, '.')[:2])
# we can now do comparisons on the two lists:
if pyver >= minver:
	sys.exit(0)
else:
	sys.exit(1)"
  changequote([, ])dnl
  if $PYTHON -c "$prog" 1>&AC_FD_CC 2>&AC_FD_CC
  then
    AC_MSG_RESULT(okay)
  else
    AC_MSG_RESULT(too old)
    PYTHON=""
  fi

  if test "x$PYTHON" != "x"
  then
    AC_MSG_CHECKING([local Python configuration])

    dnl Query Python for its version number.  Getting [:3] seems to be
    dnl the best way to do this; it's what "site.py" does in the standard
    dnl library.  Need to change quote character because of [:3]

    AC_SUBST(PYTHON_VERSION)
    changequote(<<, >>)dnl
    PYTHON_VERSION=`$PYTHON -c "import sys; print sys.version[:3]"`
    changequote([, ])dnl


    dnl Use the values of $prefix and $exec_prefix for the corresponding
    dnl values of PYTHON_PREFIX and PYTHON_EXEC_PREFIX.  These are made
    dnl distinct variables so they can be overridden if need be.  However,
    dnl general consensus is that you shouldn't need this ability.

    AC_SUBST(PYTHON_PREFIX)
    PYTHON_PREFIX='${prefix}'

    AC_SUBST(PYTHON_EXEC_PREFIX)
    PYTHON_EXEC_PREFIX='${exec_prefix}'

    dnl At times (like when building shared libraries) you may want
    dnl to know which OS platform Python thinks this is.

    AC_SUBST(PYTHON_PLATFORM)
    PYTHON_PLATFORM=`$PYTHON -c "import sys; print sys.platform"`


    dnl Set up 4 directories:

    dnl pythondir -- where to install python scripts.  This is the
    dnl   site-packages directory, not the python standard library
    dnl   directory like in previous automake betas.  This behaviour
    dnl   is more consistent with lispdir.m4 for example.
    dnl
    dnl Also, if the package prefix isn't the same as python's prefix,
    dnl then the old $(pythondir) was pretty useless.

    AC_SUBST(pythondir)
    pythondir=$PYTHON_PREFIX"/lib/python"$PYTHON_VERSION/site-packages

    dnl pkgpythondir -- $PACKAGE directory under pythondir.  Was
    dnl   PYTHON_SITE_PACKAGE in previous betas, but this naming is
    dnl   more consistent with the rest of automake.
    dnl   Maybe this should be put in python.am?

    AC_SUBST(pkgpythondir)
    pkgpythondir=\${pythondir}/$PACKAGE

    dnl pyexecdir -- directory for installing python extension modules
    dnl   (shared libraries)  Was PYTHON_SITE_EXEC in previous betas.

    AC_SUBST(pyexecdir)
    pyexecdir=$PYTHON_EXEC_PREFIX"/lib/python"$PYTHON_VERSION/site-packages

    dnl pkgpyexecdir -- $(pyexecdir)/$(PACKAGE)
    dnl   Maybe this should be put in python.am?

    AC_SUBST(pkgpyexecdir)
    pkgpyexecdir=\${pyexecdir}/$PACKAGE

    AC_MSG_RESULT([looks good])
  fi
])


dnl a macro to check for ability to create python extensions
dnl  AM_CHECK_PYTHON_HEADERS([ACTION-IF-POSSIBLE], [ACTION-IF-NOT-POSSIBLE])
dnl function also defines PYTHON_INCLUDES
AC_DEFUN([AM_CHECK_PYTHON_HEADERS],
[AC_REQUIRE([AM_PATH_PYTHON])
AC_MSG_CHECKING(for headers required to compile python extensions)
dnl deduce PYTHON_INCLUDES
py_prefix=`$PYTHON -c "import sys; print sys.prefix"`
py_exec_prefix=`$PYTHON -c "import sys; print sys.exec_prefix"`
PYTHON_INCLUDES="-I${py_prefix}/include/python${PYTHON_VERSION}"
if test "$py_prefix" != "$py_exec_prefix"; then
  PYTHON_INCLUDES="$PYTHON_INCLUDES -I${py_exec_prefix}/include/python${PYTHON_VERSION}"
fi
AC_SUBST(PYTHON_INCLUDES)
dnl check if the headers exist:
save_CPPFLAGS="$CPPFLAGS"
CPPFLAGS="$CPPFLAGS $PYTHON_INCLUDES"
AC_TRY_CPP([#include <Python.h>],dnl
[AC_MSG_RESULT(found)
$1],dnl
[AC_MSG_RESULT(not found)
$2])
CPPFLAGS="$save_CPPFLAGS"
])

dnl PKG_CHECK_MODULES_EXIST(gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
dnl defines GSTUFF_LIBS, GSTUFF_CFLAGS, see pkg-config man page
dnl also defines GSTUFF_PKG_ERRORS on error
AC_DEFUN(PKG_CHECK_MODULES_EXIST, [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $1)

        if $PKG_CONFIG --exists "$1" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes

        else
            ## If we have a custom action on failure, don't print errors, but 
            ## do set a variable so people can do so.
            PKG_ERRORS=`$PKG_CONFIG --errors-to-stdout --print-errors "$1"`
            ifelse([$3], ,PKG_ERRORS,)
        fi

     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$2], , :, [$2])
  else
     ifelse([$3], , AC_MSG_ERROR([Library requirements ($1) not met; consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a nonstandard prefix so pkg-config can find them.]), [$3])
  fi
])



