/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/macros/throwing_block_annotation.t.cpp
 *
 * @brief [LEVEL: beta] testing @ref
 * DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER and @ref
 * DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT
 *
 * $Id: throwing_block_annotation.t.cpp,v 1.13 2005/06/23 09:54:22 esdentem Exp $
 *
 * @author Christian Schallhart
 */

#include <diagnostics/unittest.hpp>

// component
#include <diagnostics/macros/throwing_block_annotation.hpp>

// backdoor
#include <diagnostics/unittest/test_system/current_test_logger.hpp>

// used component
#include <diagnostics/frame/logging_config.hpp>
#include <diagnostics/util/to_string.hpp>

// test support
#include <diagnostics/util/dummy_logger.ts.hpp>
#include <diagnostics/util/assert_record.ts.hpp>

#define TEST_COMPONENT_NAME throwing_block_annotation
#define TEST_COMPONENT_NAMESPACE diagnostics


DIAGNOSTICS_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;
using namespace unittest;
using ::diagnostics::unittest::internal::Current_Test_Logger;

#define STR_WHAT(e) (::std::string("NAME=\"") + e.name() + "\" WHAT=\"" + e.what() +"\"")

#define STR_WHAT_INT(e) (::std::string("NAME=\"int\" WHAT=\"") + ::diagnostics::internal::to_string(e)+"\"")

#define PRED true
#define EMTPY(e) ""
#define EMPTY(e) ""

#define PRED_WHAT(WHAT) (e.what()==WHAT)

#define TEST_CASE(EXPLICIT_TE) \
{ \
    Dummy_Logger * logger=new Dummy_Logger; \
    Dummy_Logger::Records_t & records(logger->records()); \
    typedef Dummy_Logger::Records_t::iterator Iter_t; \
 \
    Logging_Config::register_logger(logger); \
    Iter_t current; \
 \
    if(rethrow){ \
	TEST_THROWING_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER;  \
	throw 5; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_PROD,10,int,PRED,EMPTY,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_THROWING_BLOCK_EXIT(int); \
 \
	current=records.begin();   \
	TEST_CHECK(current->type()==TYPE_LOG_OPEN);  \
	++current;  \
 \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_TEST,20,int,PRED,EMPTY,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
 \
	TEST_THROWING_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	throw 5.5f; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_DEBUG,30,int,PRED,EMPTY,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_THROWING_BLOCK_EXIT(float); \
 \
	TEST_THROWING_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER;	 \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	throw Test_Exception("what"); \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_AUDIT,40,int,PRED,EMPTY,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_THROWING_BLOCK_EXIT1(Test_Exception,::std::string("what").c_str());	 \
 \
	TEST_THROWING_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER;	 \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	throw Test_Exception("huhu"); \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_AUDIT,50,int,PRED,EMPTY,rethrow,EXPLICIT_TE,int,STR_WHAT_INT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_THROWING_BLOCK_EXIT1(Test_Exception,::std::string("huhu").c_str()); \
 \
	TEST_THROWING_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER;	 \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	throw Test_Exception("what"); \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_AUDIT,60, \
                                             Test_Exception, \
                                             PRED_WHAT("other"), \
                                             STR_WHAT,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_THROWING_BLOCK_EXIT1(Test_Exception,::std::string("what").c_str()); \
    } \
    else { \
	TEST_EXCEPTIONLESS_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER;  \
	throw 5; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_PROD,10,int,PRED,EMPTY,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_EXCEPTIONLESS_BLOCK_EXIT; \
 \
	current=records.begin();   \
	TEST_CHECK(current->type()==TYPE_LOG_OPEN);  \
	++current;  \
 \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_TEST,20,int,PRED,EMPTY,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
 \
	TEST_EXCEPTIONLESS_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	throw "bla"; \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_DEBUG,30,int,PRED,EMPTY,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_EXCEPTIONLESS_BLOCK_EXIT; \
 \
	TEST_EXCEPTIONLESS_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER;	 \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	throw Test_Exception("what"); \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_AUDIT,40,int,PRED,EMPTY,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_EXCEPTIONLESS_BLOCK_EXIT; \
 \
	TEST_EXCEPTIONLESS_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER;	 \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	throw Test_Exception("huhu"); \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_AUDIT,50,int,PRED,EMPTY,rethrow,EXPLICIT_TE,int,STR_WHAT_INT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_EXCEPTIONLESS_BLOCK_EXIT; \
 \
	TEST_EXCEPTIONLESS_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER;	 \
	DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER; \
	throw Test_Exception("what"); \
	DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL_AUDIT,60, \
                                             Test_Exception, \
                                             PRED_WHAT("other"), \
                                             STR_WHAT,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT; \
	TEST_EXCEPTIONLESS_BLOCK_EXIT; \
    } \
     \
    Logging_Config::unregister_logger(logger); \
 \
    current=records.begin();   \
    TEST_CHECK(current->type()==TYPE_LOG_OPEN);  \
    ++current; \
 \
    TEST_ASSERT_RECORD1(LEVEL_TEST,TYPE_MISSING_EXCEPTION,20,"EXPECTED.NAME=\"int\" EXPECTED.PREDICATE=\"true\""); \
    ++current; \
    TEST_ASSERT_RECORD1(LEVEL_DEBUG,TYPE_WRONG_EXCEPTION,30,"EXPECTED.NAME=\"int\" EXPECTED.PREDICATE=\"true\""); \
    ++current; \
    TEST_ASSERT_RECORD1(LEVEL_AUDIT,TYPE_WRONG_EXCEPTION,40,"EXPECTED.NAME=\"int\" EXPECTED.PREDICATE=\"true\" " \
			"NAME=\"Test_Exception\" WHAT=\"what\""); \
    ++current; \
    if(EXPLICIT_TE==1) \
      TEST_ASSERT_RECORD1(LEVEL_AUDIT,TYPE_WRONG_EXCEPTION,50,"EXPECTED.NAME=\"int\" EXPECTED.PREDICATE=\"true\" " \
			  "NAME=\"Test_Exception\" WHAT=\"huhu\""); \
    else  \
      TEST_ASSERT_RECORD1(LEVEL_AUDIT,TYPE_WRONG_EXCEPTION,50,"EXPECTED.NAME=\"int\" EXPECTED.PREDICATE=\"true\""); \
    ++current; \
    TEST_ASSERT_RECORD1(LEVEL_AUDIT,TYPE_WRONG_EXCEPTION,60,"EXPECTED.NAME=\"Test_Exception\" " \
			"EXPECTED.PREDICATE=\"(e.what()==\"other\")\" NAME=\"Test_Exception\" WHAT=\"what\""); \
    ++current; \
 \
    TEST_CHECK(current->type()==TYPE_LOG_CLOSE); \
    TEST_CHECK(current+1==records.end()); \
    delete logger; \
 \
}


/// @todo clean up. 

void no_explicit_te(bool const rethrow)
    TEST_CASE(0)

void explicit_te(bool const rethrow)
// This test case generates code has redundant catch(Test_Exception &)
// clauses. Most compilers warn in this case. 
    TEST_CASE(1)


void no_explicit_te_rethrow(Test_Data & data)
{
    no_explicit_te(true);
}

void no_explicit_te_nothrow(Test_Data & data)
{
    no_explicit_te(false);
}


void explicit_te_rethrow(Test_Data & data)
{
    explicit_te(true);
}

void explicit_te_nothrow(Test_Data & data)
{
    explicit_te(false);
}


TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&no_explicit_te_rethrow,LEVEL_PROD);
TEST_NORMAL_CASE(&no_explicit_te_nothrow,LEVEL_PROD);
TEST_NORMAL_CASE(&explicit_te_rethrow,LEVEL_PROD);
TEST_NORMAL_CASE(&explicit_te_nothrow,LEVEL_PROD);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;

// vim:ts=4:sw=4
