/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/current_test_logger.cpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief Implementation of @ref diagnostics::unittest::internal::Current_Test_Logger
 */


#include <diagnostics/unittest/test_system/current_test_logger.hpp>

#include <diagnostics/frame/logging_config.hpp>

#include <cstdlib>
#include <stack>
#include <utility>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

class Current_Test_Logger_Implementation
{
private:
    typedef ::std::stack< ::std::pair<Logger*,bool> > Stack_t;
    typedef Current_Test_Logger_Implementation Self;
    static Self * m_instance;
    inline Current_Test_Logger_Implementation()
    {
    }

    Stack_t m_stack;
public:
    inline static Self * instance();
    static Stack_t & stack();
};

Current_Test_Logger_Implementation * Current_Test_Logger_Implementation::instance()
{
    if(m_instance==NULL) m_instance=new Self;
    return m_instance;
}

Current_Test_Logger_Implementation::Stack_t & Current_Test_Logger_Implementation::stack()
{
    return instance()->m_stack;
}

Current_Test_Logger_Implementation * Current_Test_Logger_Implementation::m_instance=NULL;



void Current_Test_Logger::push_logger(Logger * const logger)
{
    Current_Test_Logger_Implementation::stack().push(::std::pair<Logger*,bool>(logger,false));
    register_logger();
}

void Current_Test_Logger::pop_logger()
{
    unregister_logger();
    Current_Test_Logger_Implementation::stack().pop();
}


void Current_Test_Logger::unregister_logger()
{
    if(Current_Test_Logger_Implementation::stack().top().second){
	Logging_Config::unregister_logger(Current_Test_Logger_Implementation::stack().top().first);
	Current_Test_Logger_Implementation::stack().top().second=false;
    }
}

void Current_Test_Logger::register_logger()
{
    if(!Current_Test_Logger_Implementation::stack().top().second){
	Logging_Config::register_logger(Current_Test_Logger_Implementation::stack().top().first);
	Current_Test_Logger_Implementation::stack().top().second=true;
    }
}


INTERNAL_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
