/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * @file diagnostics/basic_exceptions/low_level_exception.hpp
 *
 * @author Christian Schallhart
 *
 * @version $Id: low_level_exception.hpp 296 2007-11-27 00:21:41Z tautschn $
 *
 * @brief Interface @ref ::diagnostics::Low_Level_Exception.
 *
 * @note DOCUMENTED
 */

#ifndef DIAGNOSTICS__BASIC_EXCEPTIONS__LOW_LEVEL_EXCEPTION_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__BASIC_EXCEPTIONS__LOW_LEVEL_EXCEPTION_HPP__INCLUDE_GUARD

#include <diagnostics/frame/std_exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @class Low_Level_Exception 
 *
 * @brief Interface for all low-level exceptions, i.e., exceptions
 * which are used when no further context is knwon or when the error
 * situation is only checked for in AUD_LEVEL and DEB_LEVEL. 
 *
 * For example @ref Invalid_Argument is ued in all error situations,
 * where an invalid argument has been used. If the reason for the
 * invalid argument can occur at PRO_LEVEL you either @arg catch the
 * exeption and rethrow a more helpful exception at a level where you
 * have all the information for doing so, or @arg you will throw a
 * more helpful exception right away.
 *
 * @nosubgrouping
 */
class Low_Level_Exception
    : public Std_Exception
{
	////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Types
     * @{
     */
private:
	typedef Low_Level_Exception Self;
	/// @}
	

	////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Construction/Destruction/Assignment
     * @{
     */
public:
    explicit Low_Level_Exception( ::std::string const & what );
    virtual ~Low_Level_Exception() DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
	Low_Level_Exception(Self const & other);
private:
	Low_Level_Exception();
    Self& operator=(Self const & rhs);
	/// @}
};

DIAGNOSTICS_NAMESPACE_END;

#endif /* DIAGNOSTICS__BASIC_EXCEPTIONS__LOW_LEVEL_EXCEPTION_HPP__INCLUDE_GUARD */
