/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef COMPOSER_H
#define COMPOSER_H

#include <QTextEdit>
#include <QFocusEvent>
#include <QHBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QMenu>
#include <QInputDialog>
#include <QMessageBox>
#include <QApplication>
#include <QClipboard>
#include <QMimeData> // Needed in Qt5

#include <QDebug>

class Composer : public QTextEdit
{
    Q_OBJECT

public:
    Composer(bool forPublisher);
    ~Composer();

    void erase();
    void insertLink(QString url, QString title="");

    int getMessageLabelHeight();

signals:
    void focusReceived();
    void editingFinished();
    void editingCancelled();
    void focusTitleRequested();

public slots:
    void makeNormal();
    void makeBold();
    void makeItalic();
    void makeUnderline();
    void makeStrikethrough();
    void makeHeader();
    void makeList();
    void makePreformatted();
    void makeQuote();
    void makeLink();
    void insertImage();
    void insertLine();

    void insertSymbol(QAction *action);

    void pasteAsPlaintext();

    void cancelPost();

    QPushButton *getToolsButton();

protected:
    virtual void focusInEvent(QFocusEvent *event);
    virtual void keyPressEvent(QKeyEvent *event);
    virtual void contextMenuEvent(QContextMenuEvent *event);
    virtual void insertFromMimeData(const QMimeData *source);

private:
    QHBoxLayout *mainLayout;

    QLabel *startConversationLabel;
    QPushButton *toolsButton;
    QMenu *toolsMenu;
    QMenu *symbolsMenu;

    QAction *pastePlaintextAction;

    QMenu *customContextMenu;


    bool forPublisher;
};

#endif // COMPOSER_H
