/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef MINORFEEDITEM_H
#define MINORFEEDITEM_H

#include <QFrame>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QIcon>
#include <QFile>
#include <QPushButton>

#include <QDebug>

#include "pumpcontroller.h"
#include "timestamp.h"
#include "asactivity.h"
#include "post.h"
#include "avatarbutton.h"


class MinorFeedItem : public QFrame
{
    Q_OBJECT

public:
    explicit MinorFeedItem(ASActivity *activity,
                           QStringList highlightColors,
                           bool highlightedByFilter,
                           PumpController *pumpController,
                           QWidget *parent = 0);
    ~MinorFeedItem();

    void setItemAsNew(bool isNew);
    void setFuzzyTimeStamp();

    int getItemHighlightType();
    
signals:
    void itemRead();

    
public slots:
    void openOriginalPost();
    void showUrlInfo(QString url);

protected:
    virtual void mousePressEvent(QMouseEvent *event);
    virtual void leaveEvent(QEvent *event);

private:
    PumpController *pController;

    QHBoxLayout *mainLayout;
    QVBoxLayout *leftLayout;
    QVBoxLayout *rightLayout;
    QHBoxLayout *rightLowerLayout;

    AvatarButton *avatarButton;
    QLabel *timestampLabel;
    QLabel *activityDescriptionLabel;

    QPushButton *openButton;

    QVariantMap originalObjectMap;
    QVariantMap inReplyToMap;

    bool itemIsNew;
    int itemHighlightType;
    QString createdAtTimestamp;
};

#endif // MINORFEEDITEM_H
