Module="EnhancedPaletteColorLookupTable"
	Sequence="DataFrameAssignmentSequence"				Type="1"	VM="1-3"
		Name="DataType"									Type="1"
		Name="DataPathAssignment"						Type="1"	StringEnumValues="DataPathAssignment"
		Name="BitsMappedToColorLookupTable"				Type="3"
		InvokeMacro="VOILUTMacro"
	SequenceEnd
	Sequence="BlendingLUT1Sequence"						Type="1C"	VM="1"	Condition="AnyDataPathAssignmentIsOtherThanPrimaryPValues"
		Name="BlendingLUT1TransferFunction"				Type="1"	StringEnumValues="BlendingLUT1TransferFunction"
		Name="BlendingWeightConstant"					Type="1C"	Condition="BlendingLUT1TransferFunctionIsConstant"
		Name="BlendingLookupTableDescriptor"			Type="1C"	Condition="BlendingLUT1TransferFunctionIsTable"
		Verify="BlendingLookupTableDescriptor"						ValueSelector="1"	BinaryEnumValues="Zero"	
		Name="BlendingLookupTableData"					Type="1C"	Condition="BlendingLUT1TransferFunctionIsTable"
	SequenceEnd
	Sequence="BlendingLUT2Sequence"						Type="1C"	VM="1"	Condition="AnyDataPathAssignmentIsOtherThanPrimaryPValues"
		Name="BlendingLUT2TransferFunction"				Type="1"	StringEnumValues="BlendingLUT2TransferFunction"
		Name="BlendingWeightConstant"					Type="1C"	Condition="BlendingLUT2TransferFunctionIsConstant"
		Name="BlendingLookupTableDescriptor"			Type="1C"	Condition="BlendingLUT1TransferFunctionIsTable"
		Verify="BlendingLookupTableDescriptor"						ValueSelector="1"	BinaryEnumValues="Zero"	
		Name="BlendingLookupTableData"					Type="1C"	Condition="BlendingLUT1TransferFunctionIsTable"
	SequenceEnd
	Sequence="EnhancedPaletteColorLookupTableSequence"	Type="1C"	VM="1-2"	Condition="AnyDataPathAssignmentIsOtherThanPrimaryPValues"
		Name="DataPathID"								Type="1"	StringEnumValues="DataPathID"
		Name="RGBLUTTransferFunction"					Type="1"	StringEnumValues="RGBLUTTransferFunction"
		Name="AlphaLUTTransferFunction"					Type="1"	StringEnumValues="AlphaLUTTransferFunction"
		Name="RedPaletteColorLookupTableDescriptor"		Type="1C"	Condition="RGBLUTTransferFunctionIsTable"
		Verify="RedPaletteColorLookupTableDescriptor"				ValueSelector="1"	BinaryEnumValues="Zero"	
		Name="GreenPaletteColorLookupTableDescriptor"	Type="1C"	Condition="RGBLUTTransferFunctionIsTable"
		Verify="GreenPaletteColorLookupTableDescriptor"				ValueSelector="1"	BinaryEnumValues="Zero"	
		Name="BluePaletteColorLookupTableDescriptor"	Type="1C"	Condition="RGBLUTTransferFunctionIsTable"
		Verify="BluePaletteColorLookupTableDescriptor"				ValueSelector="1"	BinaryEnumValues="Zero"	
		Name="AlphaPaletteColorLookupTableDescriptor"	Type="1C"	Condition="RGBLUTTransferFunctionIsTable"
		Verify="AlphaPaletteColorLookupTableDescriptor"				ValueSelector="1"	BinaryEnumValues="Zero"	
		Name="RedPaletteColorLookupTableData"			Type="1C"	Condition="RGBLUTTransferFunctionIsTable"
		Name="GreenPaletteColorLookupTableData"			Type="1C"	Condition="RGBLUTTransferFunctionIsTable"
		Name="BluePaletteColorLookupTableData"			Type="1C"	Condition="RGBLUTTransferFunctionIsTable"
		Name="AlphaPaletteColorLookupTableData"			Type="1C"	Condition="RGBLUTTransferFunctionIsTable"
	SequenceEnd
	Name="ICCProfile"									Type="1C"	Condition="AnyDataPathAssignmentIsOtherThanPrimaryPValues"
ModuleEnd

DefineMacro="PlanePositionVolumeMacro" InformationEntity="FunctionalGroup"
	Sequence="PlanePositionVolumeSequence"			Type="1"	VM="1"
		Name="ImagePositionVolume"					Type="1" 
	SequenceEnd
MacroEnd

DefineMacro="PlaneOrientationVolumeMacro" InformationEntity="FunctionalGroup"
	Sequence="PlaneOrientationVolumeSequence"		Type="1"	VM="1"
		Name="ImageOrientationVolume"				Type="1" 
	SequenceEnd
MacroEnd

DefineMacro="TemporalPositionMacro" InformationEntity="FunctionalGroup"
	Sequence="TemporalPositionSequence"				Type="1"	VM="1"
		Name="TemporalPositionTimeOffset"			Type="1" 
	SequenceEnd
MacroEnd

DefineMacro="ImageDataTypeMacro" InformationEntity="FunctionalGroup"
	Sequence="ImageDataTypeSequence"				Type="1"	VM="1"
		Name="DataType"								Type="1"	StringDefinedTerms="EnhancedUSVolumeDataType"
		Name="AliasedDataType"						Type="1"	StringEnumValues="YesNoFull"
		Name="ZeroVelocityPixelValue"				Type="1C"	Condition="NeedZeroVelocityPixelValue" mbpo="true"
	SequenceEnd
MacroEnd

Module="EnhancedUSSeries"
	Name="Modality"										Type="1"	StringEnumValues="USOrIVUSModality"
	Sequence="ReferencedPerformedProcedureStepSequence"	Type="1C"	VM="1"	Condition="SeriesNeedReferencedPerformedProcedureStepSequence"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
	Sequence="PerformedProtocolCodeSequence"			Type="1C"	VM="1"	NoCondition=""	mbpo="true"
		InvokeMacro="CodeSequenceMacro"
		Sequence="ProtocolContextSequence"				Type="3"	VM="1-n"
			InvokeMacro="ContentItemMacro"
			Sequence="ContentItemModifierSequence"		Type="3"	VM="1-n"
				InvokeMacro="ContentItemMacro"
			SequenceEnd
		SequenceEnd
	SequenceEnd
	Name="PerformedProtocolType"						Type="1C"	Condition="PerformedProtocolCodeSequenceIsPresent"	StringEnumValues="PerformedProtocolType"
ModuleEnd

Module="UltrasoundFrameOfReference"
	Name="VolumeFrameOfReferenceUID"						Type="1"
	Name="UltrasoundAcquisitionGeometry"					Type="1"	StringDefinedTerms="UltrasoundAcquisitionGeometry"
	Name="ApexPosition"										Type="1C"	Condition="UltrasoundAcquisitionGeometryIsApex"
	Name="VolumeToTransducerMappingMatrix"					Type="1"
	Name="PatientFrameOfReferenceSource"					Type="1C"	Condition="NeedPatientFrameOfReferenceSource"	StringEnumValues="PatientFrameOfReferenceSource"
	Name="TableFrameOfReferenceUID"							Type="1C"	Condition="PatientFrameOfReferenceSourceIsTable"
	Name="VolumeToTableMappingMatrix"						Type="1C"	Condition="PatientFrameOfReferenceSourceIsTable"
ModuleEnd

Module="EnhancedUSImage"
	Name="ImageType"										Type="1"	VM="2-n"
	Verify="ImageType"													ValueSelector="0"	StringEnumValues="CommonEnhancedImageType1"
	Verify="ImageType"													ValueSelector="1"	StringEnumValues="CommonEnhancedImageAndFrameType2"
	Verify="ImageType"													ValueSelector="2"	StringEnumValues="EmptyValue"
	Verify="ImageType"													ValueSelector="3"	StringEnumValues="EmptyValue"
	Name="SamplesPerPixel"									Type="1"	BinaryEnumValues="SamplesPerPixelIsOne"
	Name="PhotometricInterpretation"						Type="1"	StringEnumValues="PhotometricInterpretationMonochrome2"
	Name="BitsAllocated"									Type="1"	BinaryEnumValues="BitsAre8Or16"
	Name="BitsStored"										Type="1"	BinaryEnumValues="BitsAre8Or16"
	Name="HighBit"											Type="1"	BinaryEnumValues="BitsAre7Or15"
	Name="PixelRepresentation"								Type="1"	BinaryEnumValues="PixelRepresentationUnsigned"
	Name="DimensionOrganizationType"						Type="1"	StringEnumValues="DimensionOrganizationType3DOr3DTemporal"
	Name="AcquisitionDateTime"								Type="1"
	Name="AcquisitionDuration"								Type="1"
	Name="PixelSpacing"										Type="1"
	Name="PositionMeasuringDeviceUsed"						Type="1C"	Condition="NeedPositionMeasuringDeviceUsed"	StringEnumValues="PositionMeasuringDeviceUsed"	mbpo="true"
	Name="LossyImageCompression"							Type="1"	StringEnumValues="LossyImageCompression"
	Name="LossyImageCompressionRatio"						Type="1C"	Condition="LossyImageCompressionIs01"
	Name="LossyImageCompressionMethod"						Type="1C"	StringDefinedTerms="LossyImageCompressionMethod"	Condition="LossyImageCompressionIs01"
	Verify="LossyImageCompressionMethod"								Condition="LossyImageCompressionMethodInconsistentWithTransferSyntax"	ThenWarningMessage="method inconsistent with transfer syntax" ShowValueWithMessage="true"
	Name="PresentationLUTShape"								Type="1"	StringEnumValues="IdentityPresentationLUTShape"
	Name="RescaleIntercept"									Type="1"	BinaryEnumValues="Zero"
	Name="RescaleSlope"										Type="1"	BinaryEnumValues="One"
	Sequence="SourceImageSequence"							Type="1C"	VM="1-n"	Condition="ImageTypeValue1Derived"
		InvokeMacro="ImageSOPInstanceReferenceMacro"
		Sequence="PurposeOfReferenceCodeSequence"			Type="3"	VM="1"
			InvokeMacro="CodeSequenceMacro"
		SequenceEnd
	SequenceEnd
	Sequence="ReferencedImageSequence"						Type="3"	VM="1-n"
		InvokeMacro="ImageSOPInstanceReferenceMacro"
		Sequence="PurposeOfReferenceCodeSequence"			Type="3"	VM="1"
			InvokeMacro="CodeSequenceMacro"
		SequenceEnd
	SequenceEnd
	Sequence="ReferencedRawDataSequence"					Type="3"	VM="1-n"
		InvokeMacro="HierarchicalSOPInstanceReferenceMacro"
	SequenceEnd
	Sequence="ReferencedInstanceSequence"					Type="3"	VM="1-n"
		InvokeMacro="SOPInstanceReferenceMacro"
		Sequence="PurposeOfReferenceCodeSequence"			Type="3"	VM="1"
			InvokeMacro="CodeSequenceMacro"
		SequenceEnd
	SequenceEnd
	Name="NumberOfStages"									Type="1C"	Condition="PerformedProtocolTypeIsStaged"
	Name="StageNumber"										Type="1C"	Condition="PerformedProtocolTypeIsStaged"
	Sequence="StageCodeSequence"							Type="1C"	VM="1"	Condition="PerformedProtocolTypeIsStaged"
		InvokeMacro="CodeSequenceMacro"
	SequenceEnd
	InvokeMacro="MandatoryViewAndSliceProgressionDirectionMacro"
	Sequence="EventTimerSequence"							Type="3"	VM="1-n"
		Name="EventTimeOffset"								Type="1"
		Sequence="EventCodeSequence"						Type="1"	VM="1"
			InvokeMacro="CodeSequenceMacro"
		SequenceEnd
		Name="EventTimerNames"								Type="3"	VM="1"
	SequenceEnd
	InvokeMacro="GeneralAnatomyMandatoryMacro"
	Name="BurnedInAnnotation"								Type="1"	StringEnumValues="NoFull"
	Name="RecognizableVisualFeatures"						Type="3"	StringEnumValues="YesNoFull"
	Sequence="IconImageSequence"							Type="3"	VM="1"
		InvokeMacro="IconImageSequenceMacro"
	SequenceEnd
	Name="TransducerData"									Type="3"
	Sequence="TransducerScanPatternCodeSequence"			Type="1"	VM="1"
		InvokeMacro="CodeSequenceMacro"									DefinedContextID=12032"
	SequenceEnd
	Sequence="TransducerGeometryCodeSequence"				Type="1"	VM="1"
		InvokeMacro="CodeSequenceMacro"									DefinedContextID=12033"
	SequenceEnd
	Sequence="TransducerBeamSteeringCodeSequence"			Type="1"	VM="1-n"
		InvokeMacro="CodeSequenceMacro"									DefinedContextID=12034"
	SequenceEnd
	Sequence="TransducerApplicationCodeSequence"			Type="1"	VM="1"
		InvokeMacro="CodeSequenceMacro"									DefinedContextID=12035"
	SequenceEnd
	Name="ProcessingFunction"								Type="3"
	Name="MechanicalIndex"									Type="1"
	Name="BoneThermalIndex"									Type="1"
	Name="CranialThermalIndex"								Type="1"
	Name="SoftTissueThermalIndex"							Type="1"
	Name="DepthsOfFocus"									Type="1"
	Name="DepthOfScanField"									Type="1"
ModuleEnd

Module="IVUSImage"
	Name="IVUSAcquisition"									Type="1"	StringDefinedTerms="IVUSAcquisition"
	Name="IVUSPullbackRate"									Type="1C"	Condition="IVUSAcquisitionIsMotor"
	Name="IVUSGatedRate"									Type="1C"	Condition="IVUSAcquisitionIsGated"
	Name="IVUSPullbackStartFrameNumber"						Type="1C"	Condition="IVUSAcquisitionIsMotorOrGated"	NotZeroError=""
	Name="IVUSPullbackStopFrameNumber"						Type="1C"	Condition="IVUSAcquisitionIsMotorOrGated"	NotZeroError=""
ModuleEnd

Module="ExcludedIntervals"
	Sequence="ExcludedIntervalsSequence"					Type="1C"	VM="1-n"	NoCondition=""
		Name="ExclusionStartDateTime"						Type="1"
		Name="ExclusionDuration"							Type="1"
	SequenceEnd
ModuleEnd

DefineMacro="USImageDescriptionMacro" InformationEntity="FunctionalGroup"
	Sequence="USImageDescriptionSequence"				Type="1"	VM="1"
		Name="FrameType"								Type="1"	VM="2-n"
		Verify="FrameType"											ValueSelector="0"	StringEnumValues="CommonEnhancedFrameType1"
		Verify="FrameType"											ValueSelector="1"	StringEnumValues="CommonEnhancedImageAndFrameType2"
		Verify="FrameType"											ValueSelector="2"	StringEnumValues="EmptyValue"
		Verify="FrameType"											ValueSelector="3"	StringEnumValues="EmptyValue"
		Name="VolumetricProperties"						Type="1"	StringEnumValues="CommonCTMRVolumetricPropertiesImageLevel"
		Name="VolumeBasedCalculationTechnique"			Type="1"	StringDefinedTerms="CommonCTMRVolumeBasedCalculationTechniqueImageLevel"
	SequenceEnd
MacroEnd

DefineMacro="USImageDescriptionMacroForEnhancedUSVolume" InformationEntity="FunctionalGroup"
	Sequence="USImageDescriptionSequence"				Type="1"	VM="1"
		Name="VolumetricProperties"						Type="1"	StringEnumValues="Volume"
		Name="VolumeBasedCalculationTechnique"			Type="1"	StringEnumValues="None"
	SequenceEnd
MacroEnd

Module="MultiFrameFunctionalGroupsForEnhancedUSVolume"
	Sequence="SharedFunctionalGroupsSequence"			Type="2"	VM="0-1"
		InvokeMacro="PlanePositionMacro"				Condition="PlanePositionSequenceOKInSharedFunctionalGroupSequence"
		InvokeMacro="PlaneOrientationMacro"				Condition="PlaneOrientationSequenceOKInSharedFunctionalGroupSequence"
		InvokeMacro="ReferencedImageMacro"				Condition="ReferencedImageMacroOKInSharedFunctionalGroupSequence"
		InvokeMacro="DerivationImageMacro"				Condition="DerivationImageMacroOKInSharedFunctionalGroupSequence"
		InvokeMacro="CardiacSynchronizationMacro"		Condition="NeedCardiacSynchronizationMacroInSharedFunctionalGroupSequenceRegardlessOfImageType"
		InvokeMacro="FrameVOILUTMacro"					Condition="FrameVOILUTSequenceNotInPerFrameFunctionalGroupSequence"
		InvokeMacro="RealWorldValueMappingMacro"		Condition="RealWorldValueMappingMacroOKInSharedFunctionalGroupSequence"
		InvokeMacro="ContrastBolusUsageMacro"			Condition="NeedContrastBolusUsageMacroInSharedFunctionalGroupSequence"
		InvokeMacro="PatientOrientationInFrameMacro"	Condition="PatientOrientationInFrameMacroOKInSharedFunctionalGroupSequence"
		InvokeMacro="FrameDisplayShutterMacro"			Condition="FrameDisplayShutterMacroOKInSharedFunctionalGroupSequence"
		InvokeMacro="RespiratorySynchronizationMacro"	Condition="NeedRespiratorySynchronizationMacroInSharedFunctionalGroupSequenceRegardlessOfImageType"
		InvokeMacro="PlaneOrientationVolumeMacro"
		InvokeMacro="TemporalPositionMacro"				Condition="TemporalPositionMacroOKInSharedFunctionalGroupSequence"
		InvokeMacro="ImageDataTypeMacro"				Condition="ImageDataTypeSequenceNotInPerFrameFunctionalGroupSequence"
		InvokeMacro="USImageDescriptionMacro"
		InvokeMacro="USImageDescriptionMacroForEnhancedUSVolume"
	SequenceEnd

	Sequence="PerFrameFunctionalGroupsSequence"			Type="1"	VM="1-n"
		InvokeMacro="FrameContentMacro"
		InvokeMacro="PlanePositionMacro"				Condition="PlanePositionSequenceOKInPerFrameFunctionalGroupSequence"
		InvokeMacro="PlaneOrientationMacro"				Condition="PlaneOrientationSequenceOKInPerFrameFunctionalGroupSequence"
		InvokeMacro="ReferencedImageMacro"				Condition="ReferencedImageMacroOKInPerFrameFunctionalGroupSequence"
		InvokeMacro="DerivationImageMacro"				Condition="DerivationImageMacroOKInPerFrameFunctionalGroupSequence"
		InvokeMacro="CardiacSynchronizationMacro"		Condition="NeedCardiacSynchronizationMacroInPerFrameFunctionalGroupSequenceRegardlessOfImageType"
		InvokeMacro="FrameVOILUTMacro"					Condition="FrameVOILUTSequenceNotInSharedFunctionalGroupSequence"
		InvokeMacro="RealWorldValueMappingMacro"		Condition="RealWorldValueMappingMacroOKInPerFrameFunctionalGroupSequence"
		InvokeMacro="ContrastBolusUsageMacro"			Condition="NeedContrastBolusUsageMacroInPerFrameFunctionalGroupSequence"
		InvokeMacro="PatientOrientationInFrameMacro"	Condition="PatientOrientationInFrameMacroOKInPerFrameFunctionalGroupSequence"
		InvokeMacro="FrameDisplayShutterMacro"			Condition="FrameDisplayShutterMacroOKInPerFrameFunctionalGroupSequence"
		InvokeMacro="RespiratorySynchronizationMacro"	Condition="NeedRespiratorySynchronizationMacroInPerFrameFunctionalGroupSequenceRegardlessOfImageType"
		InvokeMacro="PlanePositionVolumeMacro"
		InvokeMacro="TemporalPositionMacro"				Condition="TemporalPositionMacroOKInPerFrameFunctionalGroupSequence"
		InvokeMacro="ImageDataTypeMacro"				Condition="ImageDataTypeSequenceNotInSharedFunctionalGroupSequence"
	SequenceEnd
ModuleEnd
