/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#include "fader.h"
#include "chrono.h"
#include "console.h"

extern chrono clk;

fader::fader (float vs, float ve) {
  set (vs, ve, 0);
}

void fader::set (float vs, float ve, int _on, float dt) {

  start = vs;
  end = ve;
  delta = end - start;

  if (delta < 0) flip = 1; else flip = 0;

  alpha = 0;
  amount = start;

  start_time = clk.secs;
  delta_time = dt; // secs

  on = _on;

}

int fader::eval () {

  if (on) {

    float dt = clk.secs - start_time;
    if (dt >= delta_time) {
      dt = delta_time;
      on = 0;
      if (post != "") {
        cons (post);
        post = "";
      }
    }

    alpha = dt * 1. / delta_time;

    if (flip) amount = 1 - alpha; else amount = alpha;

  }

  return on;

}

void fader::restart () {
  on = 1;
  start_time = clk.secs;
}

void fader::set_post (const std::string& pst) {
  post = pst;
}

float fader::value () {
  return (1 - alpha) * start + end * alpha;
}
