/*
* autorotator.h
* DIN Is Noise is copyright (c) 2006-2022 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __autorotator
#define __autorotator

#include "autoflip.h"
#include "alarm.h"

struct defvelaccel;

struct autorotator {

  defvelaccel& dva;

  int yes;

  enum {CLOCKWISE, ANTICLOCKWISE, RANDOM}; 
  int dir; // +1 = anti-clockwise , -1 = clockwise
  autoflipt autoflip;

  enum {TICK, SMOOTH};
  int mov;

  alarm_t tik;
  float deg;
  float tps;

  float rpm;

  struct anglett {
    float perrot;
    float theta;
    anglett () {
      perrot = 0.0f;
      theta = 0.0f;
    }
  } angle;

  autorotator (defvelaccel& d); 

  void set_rpm (float r);

  void calc (double dt);

  inline void setdeg (float d) {
    deg = d;
    if (deg < 0.0f) deg = 0.0f;
    extern const float PI_BY_180;
    angle.perrot = deg * PI_BY_180;
  }

  inline void settps (float t) {
    tps = t;
    if (tps < 1.0) tps = 1.0;
    tik.triggert = 1.0 / tps;
  }

  void chgdeg (float dd);
  void chgtps (float t);

}; 

std::ostream& operator<< (std::ostream&, autorotator& ar);
std::istream& operator>> (std::istream&, autorotator& ar);

#endif
