/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.action;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.component.dialogs.SimpleInfoDialog;
import de.xeinfach.kafenio.component.dialogs.UserInputCharacterDialog;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;

public class SpecialCharAction
extends StyledEditorKit.StyledTextAction {
    private static LeanLogger log = new LeanLogger("SpecialCharAction.class");
    private KafenioPanel parentKafenioPanel;
    private String myActionName;
    private String specialChar;

    public SpecialCharAction(KafenioPanel kafenioPanel, String string) {
        super(string);
        this.parentKafenioPanel = kafenioPanel;
        this.myActionName = string;
        log.debug("new SpecialCharAction created.");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        JEditorPane jEditorPane = this.getEditor(actionEvent);
        if (jEditorPane != null) {
            JTextPane jTextPane = this.parentKafenioPanel.getTextPane();
            int n = jTextPane.getCaretPosition();
            if (n == -1) {
                n = 0;
            }
            UserInputCharacterDialog userInputCharacterDialog = new UserInputCharacterDialog(this.parentKafenioPanel, this.getString("InsertCharacterDialogTitle"), true);
            String string = userInputCharacterDialog.getCharacter();
            userInputCharacterDialog.dispose();
            if (string != null && !string.equals("")) {
                HTMLDocument hTMLDocument = (HTMLDocument)jTextPane.getDocument();
                try {
                    hTMLDocument.insertString(n, string, null);
                }
                catch (BadLocationException badLocationException) {
                    SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.parentKafenioPanel, "", true, this.getString("ErrorNoTextSelected"), 0);
                }
            } else {
                this.parentKafenioPanel.repaint();
            }
        }
    }

    private String getString(String string) {
        return this.parentKafenioPanel.getTranslation(string);
    }
}

