/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Directory administrator; if not, send e-mail to amador@alomega.com 
*/


#ifndef __groups
#define __groups 1

#include <glib.h>
#include <lber.h>
#include <ldap.h>
#include "profile.h"
#include "pairs.h"
#include "ldaptransaction.h"

typedef struct _diradmin_group
{
  pairs_list *diradmin_group_data;
  GList *diradmin_group_members;
  GList *diradmin_group_dnmembers;
  GList *diradmin_group_objectclasses;
}
diradmin_group;


diradmin_group *diradmin_group_new (gchar * dn,
				    gchar * cn,
				    gchar * gidnumber);

diradmin_group *diradmin_group_duplicate (diradmin_group * tobeduped);

void diradmin_group_destroy (diradmin_group * todestroy);


gchar *diradmin_group_get_attribute (diradmin_group * conn, gchar * attr);

void diradmin_group_set_attribute (diradmin_group * conn, gchar * attr,
				   gchar * to);

void diradmin_group_remove_attribute (diradmin_group * conn, gchar * attr);

void diradmin_group_add_member (diradmin_group * conn, gchar * member);
void diradmin_group_remove_member (diradmin_group * conn, gchar * member);
void diradmin_group_add_dnmember (diradmin_group * conn, gchar * member);
void diradmin_group_remove_dnmember (diradmin_group * conn, gchar * member);

GList *diradmin_group_get_members (diradmin_group * conn);

void diradmin_group_set_members (diradmin_group * conn, GList * memberlist);

GList *diradmin_group_get_dnmembers (diradmin_group * conn);

void diradmin_group_set_dnmembers (diradmin_group * conn, GList * memberlist);

diradmin_group *diradmin_group_new_from_ldap (connection_profile * usethisone,
					      char *userdn);

void g_debug_free (gpointer data);

gchar *gidnumber_to_cn (connection_profile * usethisone, gchar * gidnumber);

gchar *cn_to_gidnumber (connection_profile * usethisone, gchar * cn);

ldaptransaction *diradmin_group_generate_ldapdiff
(diradmin_group * oldone, diradmin_group * newone);

diradmin_group *create_group_struct_from_dialogbox (connection_profile * conn,
						    GtkWidget * dialogbox,
						    gchar * dn);

ldaptransaction *diradmin_group_create_ldapdiff (diradmin_group * newone);

GList *diradmin_group_get_objectclasses (diradmin_group * conn);

void diradmin_group_add_objectclass (diradmin_group * conn,
				     gchar * allowedserver);

void diradmin_group_remove_objectclass (diradmin_group * conn,
					gchar * allowedserver);

void diradmin_group_set_objectclasses (diradmin_group * conn,
				       GList * allowedserverlist);

gboolean diradmin_group_has_objectclass (diradmin_group * conn,
					 gchar * allowedserver);


gboolean
diradmin_group_has_member (diradmin_group * conn, gchar * allowedserver);
void diradmin_group_dump_objectclasses (diradmin_group * conn);
#endif
