/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Directory administrator; if not, send e-mail to amador@alomega.com
*/


#include <glib.h>
#include <ldap.h>
#include <lber.h>

#ifndef __ldt_h_defined
#define __ldt_h_defined 1

typedef struct _ldaptransaction {
  LDAPMod **mods;
} ldaptransaction;

ldaptransaction * ldaptransaction_new(void);
void ldaptransaction_destroy(ldaptransaction *m);

void ldaptransaction_add(ldaptransaction *m,gchar *a,gchar **vals) ;

void ldaptransaction_delete(ldaptransaction *m,gchar *a,gchar **vals) ;
void ldaptransaction_replace(ldaptransaction *m,gchar *a,gchar **vals) ;

void ldap_dump_mods (LDAPMod ** mods);

void ldaptransaction_dump(ldaptransaction *m);


/*
hay tres tipos de operacion
aadir atributo (nombreatributo, listavalores)
  aade la lista de valores al atributo especificado
eliminar atributo (nombreatributo, listavalores)
  si se da una lista de valores, se los elimina del atributo, otherwise
  simplemente se elimina todos los valores del atributo
reemplazar atributo (nombreatributo, listavalores)
  los valores del atributo seran los pasados
*/

gboolean ldaptransaction_has_mods(ldaptransaction *m);
#endif

