%define name directory_administrator
%define version 1.7.1
%define release 1
%define prefix /usr
%define jacksonm Mike Jackson <mj@sci.fi>

Name:		%name
Summary:	User/group/access control management tool for LDAP directories
Version:	 %version
Release:	%release
Copyright:	GPL
Group:		System/Configuration/Other
URL:		http://diradmin.open-it.org/
Vendor:	%{jacksonm}
Packager:	%{jacksonm}
Source:		directory_administrator-%{version}.tar.gz
BuildRequires:	gnome-libs-devel openldap-devel
BuildRoot:	%{_tmppath}/%{name}-root

%description
Directory Administrator is an easy to use, graphical, LDAP directory
management tool. It can be used to manage UNIX users and groups, corporate
address book information, host-based access control and email routing
for large organizations, etc.

%prep
%setup

%build
./configure --prefix=%{prefix}
make

%install
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%attr(0755,root,root) %{prefix}/bin/directory_administrator
%attr(0644,root,root) %{prefix}/share/applications/*
%attr(0644,root,root) %{prefix}/share/pixmaps/directory_administrator/*
%doc AUTHORS NEWS COPYING ChangeLog TODO README doc

%changelog
* Thu Aug 4 2005 Mike Jackson <mj@sci.fi> 1.7.1
- removed reference to test.c
- corrected segmentation violation in appfunctions.c
- Changed to support the Samba v3.0 schema
- Added support for changing passwords via the LDAP_EXOP_MODIFY_PASSWD
  extended operation
- Various fixes to error handling
- Added support for mailLocalAddress mail aliases
- Added support for the Windows well known system groups

* Sat Feb 26 2005 Mike Jackson <mj@sci.fi> 1.6.0
- Updated spec file with new maintainer
- Changed descriptions
- Removed spanish language

* Fri Dec 20 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.3-1
- Bugfixes
- From now on, this changelog shows only RPM spec changes

vv
