/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include "ldaptransaction.h"

ldaptransaction * ldaptransaction_new(void) {
  ldaptransaction * m;
  m = g_new0 (ldaptransaction, 1);
  m->mods = g_new0 (LDAPMod*,1024);
  m->modifyPassword = NULL;
  return m;
}

void ldaptransaction_destroy(ldaptransaction *m) {
  g_assert(m);
  ldap_mods_free(m->mods,1);
  g_free(m);
}

void ldaptransaction_add(ldaptransaction *m,gchar *a,gchar **vals) {
  int mnum;
  g_assert(m);
  g_assert(vals);
  for (mnum=0;m->mods[mnum] != NULL;mnum++);
  m->mods[mnum] = g_new0(LDAPMod,1);
  m->mods[mnum]->mod_op = LDAP_MOD_ADD;
  m->mods[mnum]->mod_type = g_strdup (a);
  m->mods[mnum]->mod_values = vals;
}

void ldaptransaction_delete(ldaptransaction *m,gchar *a,gchar **vals) {
  int mnum;
  g_assert(m);
  for (mnum=0;m->mods[mnum] != NULL;mnum++);
  m->mods[mnum] = g_new0(LDAPMod,1);
  m->mods[mnum]->mod_op = LDAP_MOD_DELETE;
  m->mods[mnum]->mod_type = g_strdup (a);
  if (vals)
     m->mods[mnum]->mod_values = vals;
}
void ldaptransaction_replace(ldaptransaction *m,gchar *a,gchar **vals) {

  int mnum;
  g_assert(m);
  g_assert(vals);
  for (mnum=0;m->mods[mnum] != NULL;mnum++);
  m->mods[mnum] = g_new0(LDAPMod,1);
  m->mods[mnum]->mod_op = LDAP_MOD_REPLACE;
  m->mods[mnum]->mod_type = g_strdup (a);
  m->mods[mnum]->mod_values = vals;
  //g_print("\nReemplazando");
/*  verga2 = vals[0];
  for (verga=0;verga2[verga];verga++) g_print("\nVal: %d",verga2[verga]);*/
}

void ldaptransaction_set_password(ldaptransaction *m, gchar *password) {
  m->modifyPassword = password;
}


void
ldap_dump_mods (LDAPMod ** mods)
{
  LDAPMod *mod;
  int cmod, cval;

  cmod = 0;
  while (mods[cmod])
    {
      mod = mods[cmod];
      switch (mod->mod_op)
        {
        case LDAP_MOD_ADD:
          g_print ("LDAP_MOD_ADD");
          break;
        case LDAP_MOD_DELETE:
          g_print ("LDAP_MOD_DELETE");
          break;
        case LDAP_MOD_REPLACE:
          g_print ("LDAP_MOD_REPLACE");
          break;
        case LDAP_MOD_BVALUES:
          g_print ("LDAP_MOD_BVALUES");
          break;
        }
      g_print (" %s\n", mod->mod_type);
      cval = 0;
      while (mod->mod_values && mod->mod_values[cval])
        {
          g_print ("\t%s\n", mod->mod_values[cval]);
          cval++;
        }

      cmod++;
    }
   g_print("\n");
}

void ldaptransaction_dump(ldaptransaction *m) {
    ldap_dump_mods (m->mods);
}

gboolean ldaptransaction_has_mods(ldaptransaction *m) {
  int mnum;
  mnum = 0;
  if (m->mods[mnum] != NULL) return TRUE;
  return FALSE;
  //for (mnum=0;m->mods[mnum] != NULL;mnum++);
}

LDAPMod **ldaptransaction_get_mods(ldaptransaction *m) {
  return m->mods;
}

gboolean ldaptransaction_has_new_password(ldaptransaction *m) {
  if (m->modifyPassword) return TRUE;
  return FALSE;
}

gchar *ldaptransaction_get_password(ldaptransaction *m) {
  return m->modifyPassword;
}


/*
hay tres tipos de operacion
aadir atributo (nombreatributo, listavalores)
  aade la lista de valores al atributo especificado
eliminar atributo (nombreatributo, listavalores)
  si se da una lista de valores, se los elimina del atributo, otherwise
  simplemente se elimina todos los valores del atributo
reemplazar atributo (nombreatributo, listavalores)
  los valores del atributo seran los pasados
*/

/*int main(void) {

int n;
ldaptransaction*a;
gchar **values,**values2,**values3;

for (n=0;n<100000;n++) {
a = ldaptransaction_new();
values = g_new0(gchar*,2);
values[0] = g_strdup("hola");
values2 = g_new0(gchar*,2);
values2[0] = g_strdup("chao");
values3 = g_new0(gchar*,3);
values3[0] = g_strdup("comolaverga");
values3[1] = g_strdup("chepo2");

ldaptransaction_add(a,"objectclass",values);
ldaptransaction_replace(a,"dos",values2);
ldaptransaction_delete(a,"truax",values3);
ldaptransaction_dump(a);
ldaptransaction_destroy(a);
}
return(0);

}
*/
