/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#ifndef __users
#define __users 1

#include <glib.h>
#include <lber.h>
#include <ldap.h>
#include "profile.h"
#include "pairs.h"
#include "ldaptransaction.h"

typedef struct _diradmin_user
{
  pairs_list *diradmin_user_data;
  GList *diradmin_user_objectclasses;
  GList *diradmin_user_allowedservers;
  GList *diradmin_user_mails;
  gboolean allserversallowed;
}
diradmin_user;

diradmin_user *diradmin_user_new (gchar *dn, GList * allowed);

diradmin_user *diradmin_user_duplicate (diradmin_user * tobeduped);

void diradmin_user_destroy (diradmin_user * todestroy);

gchar *diradmin_user_get_attribute (diradmin_user * conn, gchar * attr);

void diradmin_user_set_attribute (diradmin_user * conn, gchar * attr,
				  gchar * to);

void diradmin_user_allowallservers (diradmin_user * conn);
void diradmin_user_revokeallservers (diradmin_user * conn);

void diradmin_user_remove_attribute (diradmin_user * conn, gchar * attr);

//its not actually a userdn, its an uid which happens to be the username heheh
diradmin_user *diradmin_user_new_from_ldap (connection_profile * usethisone,
					    char *userdn);


GList *diradmin_user_get_allowedservers (diradmin_user * conn);

void diradmin_user_add_allowedserver (diradmin_user * conn,
				      gchar * allowedserver);

void diradmin_user_remove_allowedserver (diradmin_user * conn,
					 gchar * allowedserver);

void diradmin_user_set_allowedservers (diradmin_user * conn,
				       GList * allowedserverlist);

gboolean diradmin_user_has_allowedserver (diradmin_user * conn,
					  gchar * allowedserver);

GList *diradmin_user_get_mails (diradmin_user * conn);
void diradmin_user_set_mails (diradmin_user *conn, GList *maillist);
void diradmin_user_add_mail (diradmin_user *conn, gchar *mail);
void diradmin_user_remove_mail (diradmin_user * conn, gchar * mail);
gboolean diradmin_user_has_mail (diradmin_user * conn, gchar *mail);

GList *diradmin_user_get_objectclasses (diradmin_user * conn);

void diradmin_user_add_objectclass (diradmin_user * conn,
				    gchar * allowedserver);

void diradmin_user_remove_objectclass (diradmin_user * conn,
				       gchar * allowedserver);

void diradmin_user_set_objectclasses (diradmin_user * conn,
				      GList * allowedserverlist);

gboolean diradmin_user_has_objectclass (diradmin_user * conn,
					gchar * allowedserver);

ldaptransaction*diradmin_user_generate_ldapdiff (diradmin_user * oldone,
					   diradmin_user * newone);

diradmin_user *create_user_struct_from_dialogbox (connection_profile * conn,
						  GtkWidget * dialogbox,
						  gchar * dn);

ldaptransaction*diradmin_user_create_ldapdiff (diradmin_user * newone);

void diradmin_user_set_password (diradmin_user * conn, gchar * to);
void
diradmin_user_tighten_objectclasses (diradmin_user * u);


void  diradmin_user_revokeallservers (diradmin_user *conn);
void  diradmin_user_allowallservers (diradmin_user *conn);
gboolean  diradmin_user_has_allservers (diradmin_user *conn);

#endif
