#!/usr/bin/perl -w 
#
# Copyright (C) 2001-2002 J.I. van Hemert
#
# index.cgi - connect to freedb's http server and collect an entry,
# then transform it into jewel covers using Disc-Cover.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Author: J.I. van Hemert <jvhemert@cwi.nl>
#
# Physical mail:
# J.I. van Hemert
# CWI
# P.O. Box 94079
# NL-1090 GB Amsterdam
# The Netherlands
#
#
# $Id: index.cgi,v 1.4 2002/12/07 23:50:13 jvhemert Exp $
#

use CGI qw/:standard :default_dtd/;
use strict;
#DEBUG#print "Content-Type: text/plain\n\n";
default_dtd('-//W3C//DTD HTML 4.01//EN');


if (param("results"))
{
	my $format = param("format");
	my $address = param("results");
	my $sideflap = param("sideflap");
	my $casetype = param("casetype") || "jewel";
	my $variousartistsinfo = param("variousartistsinfo") || "";
	my $genreinfo = param("genreinfo") || "";
	my $extendedtrackinfo = param("extendedtrackinfo") || "";
	my $searchfrontpicture = param("searchfrontpicture") || "";

	my $freedb_entry_filename = "/tmp/disc-cover-cgi-$$";

	my $result = safe_exec('wget', '-O', '-', '-o', '/dev/null', "$address");
	#open IN, "<result.html" or die $!; my $result; while (<IN>) { $result .= $_; } close IN;
	my ($freedb_address) = ($result =~ /(http:\/\/www\.freedb\.org\/freedb\/[a-z]+\/[0-9a-f]+)/mg);
	my $freedb_entry = safe_exec('wget', '-O', "$freedb_entry_filename", '-o', '/dev/null', "$freedb_address");
	#DEBUG print STDERR $freedb_entry;

	my @disc_cover_params = ('./disc-cover', '-b', $sideflap, $searchfrontpicture, $extendedtrackinfo, $variousartistsinfo, $genreinfo, '-c', $casetype, '-f', '-', '-o', '-');

	if ($format eq "ps")
	{
		print header(-type=>'application/postscript');
		print safe_exec(@disc_cover_params, '-t', 'ps', '-f', $freedb_entry_filename);
	}
	elsif ($format eq "pdf")
	{
		print header(-type=>'application/pdf');
		print safe_exec(@disc_cover_params, '-t', 'pdf', '-f', $freedb_entry_filename);
	}
	elsif ($format eq "tex")
	{
		print header(-type=>'text/x-tex');
		print safe_exec(@disc_cover_params, '-t', 'tex', '-f', $freedb_entry_filename);
	}
	elsif ($format eq "dvi")
	{
		print header(-type=>'application/x-dvi');
		print safe_exec(@disc_cover_params, '-t', 'dvi', '-f', $freedb_entry_filename);
	}
	elsif ($format eq "html")
	{
		print header();
		print safe_exec(@disc_cover_params, '-t', 'html', '-f', $freedb_entry_filename);
	}
	elsif ($format eq "txt")
	{
		print header(-type=>'text/plain');
		print safe_exec(@disc_cover_params, '-t', 'txt', '-f', $freedb_entry_filename);
	}
	elsif ($format eq "cddb")
	{
		print header(-type=>'text/plain');
		print safe_exec(@disc_cover_params, '-t', 'cddb', '-f', $freedb_entry_filename);
	}
	elsif ($format eq "lbl")
	{
		print header(-type=>'text/plain');
		print safe_exec(@disc_cover_params, '-t', 'lbl', '-f', $freedb_entry_filename);
	}
	else
	{
		print
			header(),
			start_html(-title=>'Disc-Cover: FreeDB -> Jewel Cover', -meta=>{'copyright'=>'Copyright 2001-2002 by J.I. van Hemert', 'keywords' => 'jewel cddb cover disc-cover freedb cddbp postscript pdf tex html txt', description=>'Create jewel covers online', 'creator' => 'jvhemert@cwi.nl'}, -text=>'black', -bgcolor=>'white', -alink=>'red', -vlink=>'#AAAAAA', -link=>'#AAAAAA'
			#-meta=>{'HTTP-EQUIV' => "Pragma", 'CONTENT' => "no-cache"}
			),
			font({-color=>"red"}, "This format is not implemented"),
			end_html();
	}

	system ("rm $freedb_entry_filename");

	exit (0);
}





print
	header(),
	start_html(
		-title=>'Disc-Cover: From FreeDB to Cover',
		-meta=>{
			'copyright'=>'Copyright 2001-2002 by J.I. van Hemert',
			'keywords' => 'jewel slim case cddb cover disc-cover freedb cddbp postscript pdf tex html txt cdcover',
			description=>'Create covers online',
			'creator' => 'jvhemert@cwi.nl'
		},
		-text=>'black',
		-bgcolor=>'white',
		-alink=>'red',
		-vlink=>'#333399',
		-link=>'blue',
		-head=>Link({-rel=>'SHORTCUT ICON', -href=>'http://jvhemert.cjb.net/favicon.ico'})
	#-meta=>{'HTTP-EQUIV' => "Pragma", 'CONTENT' => "no-cache"}
	),"\n";



print	h1("Disc-Cover online"),
	"This page enables you to testdrive ",a({-href=>"http://home.wanadoo.nl/jano/disc-cover.html"}, "Disc-Cover")," before attempting installation on your own system. Just fill in an artist and/or title below. We will search the ",a({-href=>"http://www.freedb.org"}, "FreeDB")," database and show all the results. Then, select your desired cd, the output format you want together with the type of case and we will create a cover for a jewel or slim case.",p(),"To make life even easier install Disc-Cover on your own UN*X/Linux system as it is able to detect which cd is in the drive automatically.",p();

my $test_disc_cover = `./disc-cover -v | grep ^Disc-Cover`;
print p."This system is powered by $test_disc_cover";

print p."Copyright &copy; 2001-2002 by ".a({-href=>"http://home.wanadoo.nl/jano"}, "J.I. van Hemert"),hr;

if (! -f "disc-cover")
{
	print p.font({-color=>"red"}, "Error could not find executable for Disc-Cover. Please notify the system administrator of this problem: jvhemert at cwi adot nl");
	print end_html();
	exit 0;
}


if ($test_disc_cover eq "")
{
	print p.font({-color=>"red"}, "Error when testing for Disc-Cover. Please notify the system administrator of this problem: jvhemert at cwi adot nl");
	print end_html();
	exit 0;
}

print	
	h2("Step 1: search cd"),
        start_form(-action=>"", -method=>"post"),
	b("artist / title:"),
	br,
	textfield(-name=>"q"),
	"&nbsp;",
	submit(),
	end_form(),
	p,hr;

if (param("q"))
{
	print h2("Step 2: create cover");
	my $query = param_fetch('q')->[0];
	
	$query =~ s/ /\+/g;
	my $result = safe_exec('wget', '-O', '-', '-o', '/dev/null', "http://www.freedb.org/freedb_search.php?words=$query&allfields=NO&fields=artist&fields=title&allcats=YES&grouping=none");
	#DEBUG# open IN, "<result" or die $!; my $result; while (<IN>) { $result .= $_; } close IN;
	if ($result =~ /<b>Warning<\/b>:  OCI/)
	{
		print "Something appears to be wrong with the ",a({-href=>"http://freedb.music.sk/search/index.phtml?search=$query"}, "FreeDB search engine"),", please check it out and notify the maintainers.";
	}
	else
	{
		my @entries = ($result =~ /<a href=\"(http:\/\/www.freedb.org\/freedb_search_fmt.php\?cat=[a-z]+\&id=[a-f0-9]+)\">([^<]+)<\/a>/mg);
		my $matches = @entries;
		my ($specific) = ($result =~ /lot of matches found/mg);
		#DEBUG# print STDERR "Matches found: $matches\n";
		if (defined $matches and $matches > 0)
		{
			#DEBUG# print $result;
			CGI::delete("q");
			print
				start_form(-action=>"", -method=>"post"),
				submit(-name=>"submit", -value=>"generate cover"),
				p;
				
			print h3("Output format");
			print radio_group(	-name=>'format',
						-values=>['ps', 'pdf','dvi','tex','txt','html','lbl','cddb'],
						-default=>'',
						#-linebreak=>'true',
						-columns=>1,
						-labels=>{ 	'ps' => 'PostScript',
								'pdf' => 'PDF, Acrobat users, please make sure when printing you switch off the Fit to Page option',
								'tex' => 'LaTeX',
								'html' => 'HTML',
								'txt' => 'Plain text',
								'lbl' => 'CDlabelgen',
								'cddb' => 'CDDB'
							}
			);

			print p;

			print h3("Cover type");
			print radio_group(	-name=>'casetype',
						-values=>['jewel','slim','tevion-slim','letter-slim','x-slim'],
						-default=>'',
						#-linebreak=>'true',
						-columns=>1,
						-labels=>{ 	'slim' => 'Slim',
								'x-slim' => 'Slim with exchanged flap and side',
								'jewel' => 'Jewel',
								'tevion-slim' => 'Tevion Slim',
								'letter-slim' => 'Slim that fits on letter sized paper'
							}
			);

			print p;


			print h3("Additional options");

			print checkbox(-name=>"searchfrontpicture", -checked=>0, -value=>"-allmusic", -label=>"");
			print b("search for a front cover on Allmusic")," (experimental: no success guarenteed)",br;

			print checkbox(-name=>"extendedtrackinfo", -checked=>1, -value=>"-e", -label=>"");
			print b("enable extended track info")." (sometimes contains garbage)",br;

			print checkbox(-name=>"genreinfo", -checked=>0, -value=>"-g", -label=>"");
			print b("enable genre info")," (often contains garbage)",br;

			print checkbox(-name=>"variousartistsinfo", -checked=>0, -value=>"-va", -label=>"");
			print b("enable various artist info")," (sometimes useful for collections cds)",br;
			
			print textfield(-name=>"sideflap"),b("text on sideflap")," (quite optional)",br;

			print p;

			my @values;
			my %labels;
			while (@entries)
			{
				my $address = shift @entries;
				my $name = shift @entries;
				
				push @values, $address;
				if ($name =~ /^[0-9]$/)
				{
					$name = " alternative option $name";
				}
				$labels{$address} = " $name";
			}

			print h3("Select which cd to use (".($matches/2)." found)");
			print radio_group(	-name=>'results',
						-values=>\@values,
						-default=>'',
						-linebreak=>'true',
						-labels=>\%labels
			);

			print
				end_form();
		}
		else
		{
			if (defined $specific)
			{
				print "Sorry, too many matches, be more specific";
			}
			else
			{
				print "Sorry, no matches found";
			}
		}
	}

	print p,hr;
}

print end_html;



sub safe_exec
{
	my $program = shift;
	
	my $result;
	my $pid = undef;
	die "Error: cannot fork $!" unless defined ($pid = open(SAFE_KID, "-|"));
	if ($pid == 0)
	{
		#exec('wget', "-O-", "-o/dev/null", "http://www.allmusic.com/cg/amg.dll?P=amg&opt1=2&sql=$web_search") or die "Error: can not exec wget: $!";
		exec($program, @_) or die "Error: can not exec $program $!";
	}
	else
	{
		$/ = undef;
		$result = <SAFE_KID>;
		close SAFE_KID;
		
	}
	return $result;
}

