/* $Progeny: ata.c 3839 2003-11-17 04:25:01Z dsp $ */

/* ata.c -- Scan the ATA bus
 *
 * Copyright 2001, 2002 Progeny Linux Systems, Inc.
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>

#include <stdio.h>

#include <sysdep.h>

discover_sysdep_data_t *
_discover_get_ata_raw(void)
{
    return NULL;
}

#if 0  /* Old code; we need to figure out what to do with ATA. */

#include <sys/stat.h>
#include <dirent.h>

    char path[256];
    char *line;
    char *ide_link;
    FILE *f;
    struct stat state;
    size_t len = 0;
    DIR *ideDir;                   /* Pointer to a directory            */
    struct dirent *ide_link_entry; /* ide_link is a possible link to    */
                                   /* the hdx disk.                     */

    char *model_name, *model_id;

    assert(status != NULL);

    status->code = 0;
    device = last = NULL;

    busmap = discover_conf_get_bus_map_by_name("ata", status);
    if (status->code != 0) {
        return NULL;
    }

    if (busmap->scan_never) {
        status->code = DISCOVER_EBUSDISABLED;
        return NULL;
    }

    if (ata_devices) {
        return ata_devices;
    }

    xml_devices = discover_xml_get_ata_devices(status);
    if (!xml_devices) {
        return ata_devices;
    }

    ideDir = opendir(PATH_PROC_IDE);
    if(ideDir == NULL){
        return NULL;
    }/*endif*/

    /* For each link in the PATH_PROC_IDE */
    for (ide_link_entry = readdir(ideDir); ide_link_entry;
         ide_link_entry = readdir(ideDir)) {
        ide_link = ide_link_entry->d_name;
        if (strncmp(ide_link, "hd", 2) == 0) {
            /* Make test for this hdx possible disk. */
            sprintf(path,"%s/%s", PATH_PROC_IDE, ide_link);
            if (!lstat(path, &state)) {
                /* Not so fast!  Make sure that the device isn't being
                 * handled by the IDE-SCSI driver; otherwise, the
                 * device might show up twice (for example, CD burners with
                 * CD-ROM detection).
                 */
                sprintf(path, "%s/%s/driver", PATH_PROC_IDE, ide_link);
                if (!(f = fopen(path, "r"))) {
                    return NULL;
                }
                line = NULL;
                getline(&line, &len, f);
                fclose(f);
                line[8] = 0x00;
                if (!strcmp(line, "ide-scsi")) {
                    continue;
                }

                /* Get model. */
                sprintf(path, "%s/%s/model", PATH_PROC_IDE, ide_link);
                if (!(f = fopen(path, "r"))) {
                    return NULL;
                }
                getline(&line, &len, f);
                fclose(f);

                model_name = line;
                model_name[strlen(model_name) - 1] = '\0'; /* Chomp! */
                line = NULL;

                /* Determine the drive type (floppy, hd...). */
                sprintf(path, "%s/%s/media", PATH_PROC_IDE, ide_link);
                if (!(f = fopen(path, "r"))){
                    return NULL;
                }
                getline(&line, &len, f);
                fclose(f);

                model_id = line;
                model_id[strlen(model_id) - 1] = '\0'; /* Chomp! */
                line = NULL;

                device = discover_xml_find_device(xml_devices, NULL,
                                                  model_id, status);

                new_device = discover_device_new();

                if (device) {
                    discover_device_copy(device, new_device);

                    if (new_device->model_id) {
                        free(new_device->model_id);
                    }

                    if (new_device->model_name) {
                        free(new_device->model_name);
                    }
                }

                new_device->model_id = model_id;
                new_device->model_name = model_name;

                if (last) {
                    last->next = new_device;
                    last = new_device;
                } else {
                    ata_devices = last = new_device;
                }
            }
        }
    }

    closedir(ideDir);
#endif

/*
 * Local variables:
 * c-file-style: "progeny"
 * indent-tabs-mode: nil
 * End:
 */
/* vim: set cin fo=tcroq sw=4 et sts=4 tw=75: */
