#
# list.py - DITrack 'list' command
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: list.py 1224 2007-01-30 08:03:56Z gli $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.5/DITrack/Command/list.py $
#
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation 
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.
#

import os

# DITrack modules
import DITrack.Command.generic


class Handler(DITrack.Command.generic.Handler):
    canonical_name = "list"
    description = """List issues, possibly filtering.
usage: %s [FILTER...]""" % canonical_name

    def run(self, opts, globals):
        self.check_options(opts)

        db = DITrack.Util.common.open_db(globals, opts)

        filters = []

        for e in opts.fixed[1:]:
            try:
                f = DITrack.DB.Filter(e)
            except DITrack.DB.FilterIsPredefinedError:
                if e in db.cfg.filters:
                    f = db.cfg.filters[e]
                else:
                    DITrack.Util.common.err("ERROR: '%s' is not a predefined filter" % e)
            except DITrack.DB.FilterExpressionError:
                DITrack.Util.common.err("ERROR: '%s' contains a syntax error" % e)

            filters.append(f)

        for id, issue in db.issues():
            matches = None
            for f in filters:
                if f.matches(issue):
                    matches = True

            if filters and not matches: continue

            print "%-4s %-8s %-8s %-6s %s" % (
                id,
                issue.info["Owned-by"],
                issue.info["Due-in"],
                issue.info["Status"],
                issue.info["Title"]
                )
