#!/usr/bin/env python
#
# upgrade-0.5-db.py - utility to convert database format from version 2 (0.5)
#   to version 3 (0.6)
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: upgrade-0.5-db.py 1954 2007-08-26 20:33:06Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.7/upgrade-0.5-db.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

import os
import sys

if len(sys.argv) != 2:
    sys.stderr.write("""
This is a utility to convert DITrack database from format 2 (DITrack version
0.5) to format 3 (DITrack 0.6).

Usage:
    %s DBPATH

""" % sys.argv[0])

    sys.exit(1)

dbpath = sys.argv[1]

version = os.popen("svn pg ditrack:format %s" % (dbpath), "r").readline().strip()

if version != "2":
    sys.stderr.write("Unsupported database format version: %s" % version)
    sys.exit(1)

listing_format = "%s/etc/listing-format" % (dbpath)
open(listing_format, "w").write(
"""[listing-formats]
default: %(id)-4s %(Owned-by)-8s %(Due-in)-8s %(Status)-6s %(Title)s
"""
)

os.system("svn ps ditrack:format 3 %s" % (dbpath))
os.system("svn add %s" % listing_format)
sys.stdout.write("""
Database was successully converted

Now you should probably type something like:

svn commit %s

""" % (dbpath))
