#include "list.h"
#include <qlistview.h>
#include <dirent.h>
#include "dirview.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <qpixmap.h>
#include <stdlib.h>
#include <unistd.h>
#include <qtabwidget.h>
#include <ctype.h>
#include <qpopupmenu.h>
#include <qobjcoll.h>
#include "virlist.h"
#include <stdio.h>
#include "playlist.h"
#include "scanthread.h"
#include <qfileinfo.h>
#include <qapplication.h>
#include <qmessagebox.h>

#include "dir.xpm"
#include "file.xpm"
#include "up.xpm"

void List::resizeEvent(QResizeEvent *e)
{
	lv->resize(e->size().width()-10, e->size().height()-10);
	lv->setColumnWidth(0, e->size().width()-174);
	lv->setColumnWidth(1, 70);
	lv->setColumnWidth(2, 70);
	lv->repaint();
}

List::List(QWidget *parent, Playlist *p, const char *name, WFlags f) : QWidget(parent, name, f)
{
	pl=p;
	p_dir=new QPixmap((const char **)dir_xpm);
	p_file=new QPixmap((const char **)file_xpm);
	p_up=new QPixmap((const char **)up_xpm);
	dir="";
	lv=new QListView(this);
	lv->move(5, 5);
	lv->addColumn(dir);
	lv->addColumn("BPM");
	lv->addColumn("Time");
	lv->setColumnWidthMode(0, QListView::Manual);
	lv->setColumnWidthMode(0, QListView::Manual);
	lv->setAllColumnsShowFocus(true);
	lv->setColumnAlignment(1, AlignRight);
	lv->setColumnAlignment(2, AlignRight);
	lv->setSelectionMode(QListView::Extended);

	connect(lv, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(lv_doubleClicked(QListViewItem *)));
	connect(lv, SIGNAL(rightButtonPressed(QListViewItem *, const QPoint&, int)), this, SLOT(lv_rightClicked(QListViewItem *, const QPoint&, int)));
}

void List::load()
{
	int initial=1;
	if(lv->firstChild())
		initial=0;
	lv->clear();

	chdir(dir);
	DIR *dirp=opendir(dir);
	if(!dirp)
		return;
	struct dirent *entry;

	pl->scanThread()->pause(true);
	lv->setEnabled(false);
	lv->setUpdatesEnabled(false);
	lv->setSorting(-1, true);
	int ev_counter=20;
	while((entry=readdir(dirp)))
	{
		if((QString)".." != entry->d_name &&
		   entry->d_name[0] == '.')
		   	continue;
		if(dir == "/" && (QString)".." == entry->d_name)
			continue;
		QString path=dir+"/"+entry->d_name;
		struct stat st;
		if(stat(path, &st) < 0)
			continue;
		char cname[strlen(entry->d_name)+1];
		strcpy(cname, entry->d_name);
		char *up=cname;
		while(up && *up)
		{
			(*up)=toupper((*up));
			++up;
		}
		if(S_ISDIR(st.st_mode) || strstr(cname, ".MP3") ||
				 strstr(cname, ".MP2") ||
				 strstr(cname, ".MUS") ||
				 strstr(cname, ".MPG") ||
				 strstr(cname, ".MPEG") ||
				 strstr(cname, ".OGG") ||
				 strstr(cname, ".WAV"))
		{
			DirViewItem *it=new DirViewItem(lv, entry->d_name, S_ISDIR(st.st_mode));
			if(S_ISDIR(st.st_mode))
			{
				if((QString)".." != entry->d_name)
					it->setPixmap(0, *p_dir);
				else
				{
					it->setPixmap(0, *p_up);
					if(!initial)
						lv->ensureItemVisible(it);
				}
			}
			else
			{
				it->setPixmap(0, *p_file);
				QFileInfo info(entry->d_name);
				it->setText(3, info.absFilePath());
				pl->scanThread()->addFile(this, info.absFilePath(), it);
				it->setScanItem(ScanItem(pl->scanThread(), this, info.absFilePath(), it));
				--ev_counter;
				if(ev_counter <= 0)
				{
					app->processOneEvent();
					ev_counter=20;
				}
			}
		}
	}

	closedir(dirp);
	lv->setSorting(0, true);
	lv->setUpdatesEnabled(true);
	lv->setEnabled(true);
	lv->sort();
	lv->update();
	pl->scanThread()->pause(false);
}

List::~List()
{
}

void List::lv_doubleClicked(QListViewItem *it)
{
	DirViewItem *dv=(DirViewItem *)it;
	if(!dv->isDir())
	{
		pl->doubleClick();
		return;
	}
	
	pl->scanThread()->removeList(this);
	pl->scanThread()->setSkip();
	chdir(dir);
	chdir(dv->text(0));
	char *dirp=getcwd(NULL, 0);
	dir=dirp;
	lv->setColumnText(0, dir);
	if(tab_name == "" || tab_name == QString::null)
	{
		QTabWidget *p=(QTabWidget *)parent()->parent();
		p->changeTab(this, dir);
	}
	free(dirp);
	load();
}

void List::setDir(QString i_dir)
{
	dir=i_dir;
	load();
}

QString List::getDir()
{
	return dir;
}

QString List::getTitle()
{
	if(tab_name != QString::null && tab_name != "")
		return tab_name;
	return dir;
}

void List::setTitle(QString title)
{
	tab_name=title;
}

void List::setFile(QString i_file)
{
}

void List::lv_rightClicked(QListViewItem *it, const QPoint& pos, int col)
{
	if(!it)
		return;
	DirViewItem *dv=(DirViewItem *)it;
	if(dv->isDir())
		return;
	QPopupMenu *menu=new QPopupMenu(this);
	menu->insertItem("Load left", pl, SLOT(left_clicked()));
	menu->insertItem("Load right", pl, SLOT(right_clicked()));
	VirList *autolist=0;
	QObjectList *ch=parent()->queryList("VirList");
	if(ch)
	{
		if(ch->count())
		{
			menu->insertSeparator();
			QPopupMenu *submenu=new QPopupMenu(menu);

			QObjectListIt i(*ch);
			QObject *obj;
			while((obj=i.current()) != 0)
			{
				++i;
				VirList *list=(VirList *)obj;
				if(list->isA("PlayerList"))
					autolist=list;
				int id=submenu->insertItem(list->getTitle(), this, SLOT(moveToList(int)));
				submenu->setItemParameter(id, (int)list);
			}
			menu->insertItem("Send to", submenu);
		}
	}
	if(autolist)
	{
		int id=menu->insertItem("Set Auto list", this, SLOT(setAutoList(int)));
		menu->setItemParameter(id, (int)autolist);
	}
	menu->insertItem("Select all", this, SLOT(selectAll()));
	delete ch;

	menu->popup(pos);
}

void List::moveToList(int arg)
{
	List *list=(List *)arg;
    if(!list)
        return;

	lv->setEnabled(false);
    QListViewItem *it=lv->firstChild();
    while(it)
    {
        if(it->isSelected())
        {
			if(((DirViewItem *)it)->isDir())
			{
				it=it->nextSibling();
				continue;
			}
            QString path=it->text(3);
            list->addFile(path);
			app->processEvents(10);
        }
        it=it->nextSibling();
    }
	lv->setEnabled(true);
}

QString List::getSelectedFile()
{
    DirViewItem *item=(DirViewItem *)lv->currentItem();
    if(!item)
        return QString::null;
    if(item->isDir())
        return QString::null;
    QString path=item->text(3);
    return path;
}

void List::addFile(QString file, bool s)
{
}

void List::setAutoList(int arg)
{
    List *list=(List *)arg;
    if(!list)
        return;

	if(QMessageBox::warning(this, "Overwrite warning", "Are you sure you want to replace the contents of the Auto list with the contents of this list? Contents of the Auto list will be lost!", "Yes", "No", 0, 0, 1) != 0)
		return;

	list->lv->clear();
	pl->scanThread()->removeList(list);

    QListViewItem *it=lv->firstChild();
	lv->setEnabled(false);
    while(it)
    {
		DirViewItem *dv=(DirViewItem *)it;
		if(!dv->isDir())
		{
			QString path=it->text(3);
			list->addFile(path);
		}
		it=it->nextSibling();
    }
	lv->setEnabled(true);
}

void List::selectAll()
{
	DirViewItem *dv=(DirViewItem *)lv->firstChild();
	while(dv)
	{
		if(!dv->isDir())
			lv->setSelected(dv, true);
		else
			lv->setSelected(dv, false);
		dv=(DirViewItem *)dv->nextSibling();
	}
}

