#ifndef _AUDIOFILE_STREAM_SOURCE_H_INCLUDED
#define _AUDIOFILE_STREAM_SOURCE_H_INCLUDED

#include "config.h"

#ifdef HAVE_LIBAUDIOFILE

#include "jack.h"
extern "C" {
#include <audiofile.h>
}

class AudiofileStreamSource : public StreamSource
{
Q_OBJECT

public:
	AudiofileStreamSource(QWidget *dest);
	~AudiofileStreamSource();

	int attach(QString name);
	int get_buffer(char *, int);
	int play(unsigned long start_frame, unsigned long samples, bool loop=false);
	int stop(void);
	void exit_loop(void);
	StreamSource *get_source(void);
private:
	AFfilehandle fp;
	int fd;
	unsigned long file_pos;
	int track_id;
};
#endif /* HAVE_LIBAUDIOFILE */
#endif
