#include "config.h"
#ifdef HAVE_LIBSOUNDTOUCH

#include <qstring.h>
#include <stdlib.h>
#include <stdio.h>
#include <qdir.h>
#include <dlfcn.h>
#include <math.h>

#include "soundtoucheffect.h"

SoundTouchEffectChannel::SoundTouchEffectChannel(SoundTouchEffect *e, unsigned long in, unsigned long out) : EffectChannel(e, in, out)
{
	e_slave=false;
	e_effect=e;
}

SoundTouchEffectChannel::SoundTouchEffectChannel(SoundTouchEffectChannel *c, SoundTouchEffect *e, unsigned long in, unsigned long out) : EffectChannel(c, e, in, out)
{
	e_slave=true;
	e_effect=e;
}

SoundTouchEffectChannel::~SoundTouchEffectChannel()
{
}

void SoundTouchEffectChannel::setBuffer(float *data)
{
}

void SoundTouchEffectChannel::process(unsigned long nsamples)
{
}

SoundTouchEffect::SoundTouchEffect()
{
	e_left=NULL;
	e_right=NULL;
}

SoundTouchEffect::~SoundTouchEffect()
{
	if(e_right)
		delete e_right;
	if(e_left)
		delete e_left;
}

unsigned long SoundTouchEffect::ports()
{
	return 1;
}

void SoundTouchEffect::setControl(unsigned long port, float data)
{
}

float SoundTouchEffect::control(unsigned long port)
{
	return 0.0;
}

void SoundTouchEffect::process(unsigned long nsamples)
{
	((SoundTouchEffectChannel *)e_left)->process(nsamples);
	((SoundTouchEffectChannel *)e_right)->process(nsamples);
}

SoundTouchEffectChannel *SoundTouchEffect::left()
{
	return (SoundTouchEffectChannel *)e_left;
}

SoundTouchEffectChannel *SoundTouchEffect::right()
{
	return (SoundTouchEffectChannel *)e_right;
}
#endif
