/*
**  Copyright (c) 2006, 2007 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: config.h,v 1.2 2007/03/05 20:52:53 msk Exp $
*/

#ifndef _CONFIG_H_
#define _CONFIG_H_

#ifndef lint
static char config_h_id[] = "@(#)$Id: config.h,v 1.2 2007/03/05 20:52:53 msk Exp $";
#endif /* !lint */

/* system includes */
#include <stdio.h>

/* dkim-filter includes */
#include "dkim-filter.h"

/* types and things */
#define	CONFIG_TYPE_STRING	0
#define	CONFIG_TYPE_INTEGER	1
#define	CONFIG_TYPE_BOOLEAN	2

struct config
{
	u_int		cfg_type;
	char *		cfg_name;
	void *		cfg_data;
	struct config *	cfg_next;
};

struct configdef
{
	char *		cd_name;
	u_int		cd_type;
	u_int		cd_req;
};

/* prototypes */
extern char *config_check __P((struct config *, struct configdef *));
extern void config_free __P((struct config *));
extern int config_get __P((struct config *, const char *, void *));
extern struct config *config_load __P((FILE *, struct configdef *,
                                       unsigned int *));

#endif /* _CONFIG_H_ */
