/*
**  Copyright (c) 2007 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: stats.h,v 1.3 2007/05/18 17:48:44 msk Exp $
*/

#ifndef _STATS_H_
#define _STATS_H_

#ifndef lint
static char stats_h_id[] = "@(#)$Id: stats.h,v 1.3 2007/05/18 17:48:44 msk Exp $";
#endif /* !lint */

/* system includes */
#include <sys/param.h>
#include <sys/types.h>

/* libsm includes */
#include <sm/gen.h>
#include <sm/cdefs.h>

/* libdb includes */
#include <db.h>

/* libdkim includes */
#include <dkim.h>

#ifndef MAXHOSTNAMELEN
# define MAXHOSTNAMELEN	256
#endif /* ! MAXHOSTNAMELEN */

/* data types */
struct dkim_stats_key
{
	dkim_canon_t	sk_hdrcanon;
	dkim_canon_t	sk_bodycanon;
	char		sk_sigdomain[MAXHOSTNAMELEN + 1];
};

struct dkim_stats_data
{
	bool		sd_lengths;
	int		sd_lastversion;
	time_t		sd_lastseen;
	dkim_alg_t	sd_lastalg;
	u_long		sd_pass;
	u_long		sd_fail;
};

/* PROTOTYPES */
extern void dkimf_stats_init __P((void));
extern void dkimf_stats_record __P((const char *, const char *, dkim_canon_t,
                                    dkim_canon_t, dkim_alg_t, int, bool, bool,
                                    bool));

#endif /* _STATS_H_ */
