/*
 *  DNAS / a Distributed Network Application System
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * function to connect to host with DNAS options.
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "config.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libnodeinfo.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-servent-libroute.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "dmachinemon/dmachinemon-master.h"
#include "dmachinemon/dmachinemon-daemonize.h"

/**
 *  Connect to host using arbitrary options.
 *
 * This is a wrapper over dm_connect_to_host, which will use rsh or ssh
 * to connect to remote host if necessary, using dnas-proxy-shell.
 *
 * By default, it  will connect with plain socket over TCP/IP.
 *
 * @return -1 on error.
 */
int
DNAS_connect_to_host (const dm_commandoption*cdat, const char * uplink_host, int uplink_port, int connection_is_a_client/** connection is from a client and not a node. Usually true for any connection except for dnas servent. */)
{
  int fd = -1;
  
  if (cdat->rsh)
    {
      /* rsh processing comes here. */
      int filedes[2];
      if (-1 == socketpair(SOCK_STREAM, AF_LOCAL, 0, filedes))
	{
	  /* error */
	  return -1;
	}
      
      if (!fork())
	{
	  /* child process */
	  char * buf = NULL;
	  
	  asprintf (&buf, "%s %s %s/%s -p %i %s", cdat->rsh, uplink_host, LIBEXECDIR, "dnas-proxy-shell",
		    uplink_port,
		    connection_is_a_client ? "-k" : "");
	  	  
	  close(filedes[0]);
	  dup2 (filedes[1],0);
	  dup2 (filedes[1],1);
	  
	  system (buf);
	  close (0);
	  close (1);
	  
	  exit (0);
	}
      else
	{
	  close(filedes[1]);
	  fd = filedes[0];
	}
      return fd;
    }
  else
    {
      return dm_connect_to_host (uplink_host, uplink_port);
    }
}
