/*
 *  DNAS module tester / string car/cdr testing
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *$Id: test-stringcar.c,v 1.2 2002/11/17 20:33:51 dancer Exp $
 */


#include <stdio.h>
#include <stdlib.h>

#include "dmachinemon/dmachinemon.h"

void
comparefunction (const char * one, const char *two, const char * message)
{
  if (strcmp(one, two))
    {
      printf ("[%s] and [%s] differ in %s\n", one, two, message);
      exit (1);
    }
  
}

int
main(int ac, char ** av)
{
  const char * hoge = "a,b,cde,fff";
  
  comparefunction(dm_get_itemsexceptfirst (hoge),"b,cde,fff","exceptfirst");
  comparefunction(dm_get_itemsexceptlast (hoge),"a,b,cde","exceptlast");
  comparefunction(dm_get_lastitem (hoge),"fff","lastitem");
  comparefunction(dm_get_firstitem (hoge),"a","firstitem");
  return 0;
}
