#ifndef TerseReporter_h
#include "TerseReporter.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef File_h
#include "File.h"
#endif

using namespace doctorj;

TerseReporter::TerseReporter(ostream& os) : Reporter(os)
{
}

TerseReporter::~TerseReporter()
{
}

void TerseReporter::writeError(const ReportedError& err)
{
    ostream& os = stream();   

    int stcol  = err.startPosition - err.startOfFirstLine;
    int endcol = err.lastPosition  - err.startOfLastLine;

    os << err.file->name() << ":"
       << err.startLine    << ":"
       << stcol            << ":"
       << err.lastLine     << ":"
       << endcol           << ": " // space after colon
       << err.type         << ": "
       << err.message      << endl;
}
