#ifndef UserPreferences_h
#include "UserPreferences.h"
#endif

#ifndef Platform_h
#include "Platform.h"
#endif

#ifndef doctorj_stdio
#define doctorj_stdio
#include <stdio.h>
#endif

using namespace std;

using namespace doctorj;

UserPreferences* UserPreferences::instance_ = NULL;

ostream& doctorj::operator<<(ostream& os, const UserPreferences& up)
{
    os << "UserPreferences = { ";
    os << "contextOutput = " << up.contextOutput << ", ";
    os << "tabWidth = " << up.tabWidth << ", ";
    os << "debug = " << up.debug << ", ";
    os << "checkDocumentation = " << up.checkDocumentation << ", ";
    os << "checkStatistics = " << up.checkStatistics << " }";
    
    return os;
}

UserPreferences* UserPreferences::get()
{
    if (instance_ == NULL) {
        instance_ = new UserPreferences();
    }
    return instance_;
}

UserPreferences::UserPreferences() 
        : contextOutput(true),
     tabWidth(4),
     debug(""),
     checkDocumentation(true),
     checkStatistics(false),
     checkSyntax(false),
     javaVersion(1.3),
     maxMethodLength(36),       // need a starting point for this. Screensize?
     formatInstanceFinalPublic("^[A-Z_]+$"),
     formatInstanceFinalProtected("^[A-Z_]+$"),
     formatInstanceFinalPackage("^[A-Z_]+$"),
     formatInstanceFinalPrivate("^[A-Z_]+$"),
     formatInstanceNonfinalPublic("^[a-z][a-zA-Z0-9]*$"),
     formatInstanceNonfinalProtected("^_[a-z][a-zA-Z0-9]*$"),
     formatInstanceNonfinalPackage("^_[a-z][a-zA-Z0-9]*$"),
     formatInstanceNonfinalPrivate("^_[a-z][a-zA-Z0-9]*$"),
     formatStaticFinalPublic("^[A-Z_]+$"),
     formatStaticFinalProtected("^[A-Z_]+$"),
     formatStaticFinalPackage("^[A-Z_]+$"),
     formatStaticFinalPrivate("^[A-Z_]+$"),
     formatStaticNonfinalPublic("^[a-z][a-zA-Z0-9]*$"),
     formatStaticNonfinalProtected("^[a-z][a-zA-Z0-9]*$"),
     formatStaticNonfinalPackage("^[a-z][a-zA-Z0-9]*$"),
     formatStaticNonfinalPrivate("^[a-z][a-zA-Z0-9]*$"),
     fix(false),
     backupSuffix(".bak"),
     backupDirectory(""),
     eolnType("Unix")
{
    int i = 0;
    formats[i++] = formatInstanceFinalPublic;
    formats[i++] = formatInstanceFinalProtected;
    formats[i++] = formatInstanceFinalPackage;
    formats[i++] = formatInstanceFinalPrivate;
    formats[i++] = formatInstanceNonfinalPublic;
    formats[i++] = formatInstanceNonfinalProtected;
    formats[i++] = formatInstanceNonfinalPackage;
    formats[i++] = formatInstanceNonfinalPrivate;
    formats[i++] = formatStaticFinalPublic;
    formats[i++] = formatStaticFinalProtected;
    formats[i++] = formatStaticFinalPackage;
    formats[i++] = formatStaticFinalPrivate;
    formats[i++] = formatStaticNonfinalPublic;
    formats[i++] = formatStaticNonfinalProtected;
    formats[i++] = formatStaticNonfinalPackage;
    formats[i++] = formatStaticNonfinalPrivate;

    Platform::getEnv("CLASSPATH", &classPath);
}

UserPreferences::~UserPreferences()
{
}

void UserPreferences::getFormats(bool isStatic, 
                                 bool isFinal, 
                                 string fmts[], 
                                 int maxFmts) const
{
    int index = isStatic ? 8 : 0;
    index += isFinal ? 0 : 4;
    for (int ti = 0, fi = index; ti < 4 && ti < maxFmts; ++ti, ++fi) {
        fmts[ti] = formats[fi];
    }
}
