#ifndef HierarchyTextPrinter_h
#include "HierarchyTextPrinter.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace std;
using namespace doctorj;

void HierarchyTextPrinter::print(AstNode* const n, int level /* = 0 */)
{
    indent(cout, level);
    
    cout << "<" << n->type() << "> ";
    cout << endl;

    // show all the components, and so on
    list<AstItem*>::const_iterator start = n->components().begin();
    list<AstItem*>::const_iterator stop = n->components().end();
    int i = 0;
    for (list<AstItem*>::const_iterator it = start; it != stop; ++it) {
        AstItem* component = *it;
        if (component == NULL) {
            indent(cout, level + 1);
            cout << "component #" << i << " = null" << endl;
        }
        else {
            AstNode* node = dynamic_cast<AstNode*>(component);
            if (node) {
                print(node, level + 1);
            }
            else {
                AstValue* value = dynamic_cast<AstValue*>(component);
                if (value) {
                    print(value, level + 1);
                }
                else {
                    print(component, level + 1);
                }
            }
        }
        ++i;
    }
}

void HierarchyTextPrinter::print(AstItem* const i, int level /* = 0 */)
{
    indent(cout, level);
    cout << "<" << i->type() << "> ";
    int ln = i->line();
    int pos = i->column();
    //cout << i->sourceFile()->name() << "[" << ln << ":" << pos << "] ";
    cout << "[" << ln << ":" << pos << "] ";
    cout << endl;
}

void HierarchyTextPrinter::print(AstValue* const v, int level /* = 0 */)
{
    indent(cout, level);
    cout << "'" << v->text() << "' ";
    int ln = v->line();
    int pos = v->column();
    // end is the _last_ character, so take off one.
    int end = v->column() + v->text().length() - 1;
    cout << "<" << v->type() << "> ";
    //cout << v->sourceFile()->name() << "[" << ln << ":" << pos << ":" << ln << ":" << end << "] ";
    cout << "[" << ln << ":" << pos << ":" << ln << ":" << end << "] ";
    cout << endl;
}
