#ifndef ClassDocumentationAnalyzer_h
#include "ClassDocumentationAnalyzer.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef DocumentationErrors_h
#include "DocumentationErrors.h"
#endif

using namespace doctorj;

ClassDocumentationAnalyzer::ClassDocumentationAnalyzer(Reporter* const reporter,
                                                       AstItem* const cls,
                                                       AstIdentifier* const identifier,
                                                       AstModifierList* const modifiers) :
        ClassInterfaceDocumentationAnalyzer(reporter, modifiers),
     class_(cls),
     identifier_(identifier)
{
    check();
}

ClassDocumentationAnalyzer::ClassDocumentationAnalyzer()
{
}

ClassDocumentationAnalyzer::~ClassDocumentationAnalyzer()
{
}

string ClassDocumentationAnalyzer::type() const
{
    return "class";
}

AstItem* ClassDocumentationAnalyzer::getSubject()
{
    return identifier_;
}

AstNoncode* ClassDocumentationAnalyzer::leadingNoncode()
{
    return class_->leadingNoncode();
}

ErrorInvalidJavadocTag* ClassDocumentationAnalyzer::makeUnknownTagError(AstItem* const item, 
                                                                        const string& tag) const
{
    return new ErrorInvalidJavadocTagClass(reporter(), item, tag);
}
