#ifndef ClassDocumentationAnalyzer_h
#define ClassDocumentationAnalyzer_h

#ifndef ClassInterfaceDocumentationAnalyzer_h
#include "ClassInterfaceDocumentationAnalyzer.h"
#endif

namespace doctorj
{
    class AstClassDeclaration;
    class AstIdentifier;
    class AstItem;
    class AstModifierList;
    class AstNoncode;
    class Reporter;

    class ClassDocumentationAnalyzer : public ClassInterfaceDocumentationAnalyzer
    {
    public:
        /**
         * Checks the given code.
         */
        ClassDocumentationAnalyzer(Reporter* const reporter,
                                   AstItem* const cls,
                                   AstIdentifier* const identifier,
                                   AstModifierList* const modifiers);

        /**
         * Useful only for extracting the valid tags, and other such methods
         * that do not require a class, reporter, etc. Performs no checks.
         */
        ClassDocumentationAnalyzer();

        virtual ~ClassDocumentationAnalyzer();

        /**
         * Returns the noncode preceding the class declaration. This noncode
         * should contain the Javadoc comment, if any.
         */
        virtual AstNoncode* leadingNoncode();

        /**
         * What type of object we're analyzing, a "class".
         */
        virtual string type() const;

        /**
         * The identifier of what we're analyzing.
         */
        virtual AstItem* getSubject();

        /**
         * Creates the error for the usage of an invalid tag with a class.
         */
        virtual ErrorInvalidJavadocTag* makeUnknownTagError(AstItem* const item, 
                                                            const string& tag) const;

    private:
        /**
         * The class declaration being analyzed.
         */
        AstItem* class_;

        /**
         * The identifier (name) of the class being analyzed.
         */
        AstIdentifier* identifier_;

    };
}

#endif //! ClassDocumentationAnalyzer_h
