#ifndef ClassInterfaceDocumentationAnalyzer_h
#define ClassInterfaceDocumentationAnalyzer_h

#ifndef ItemDocumentationAnalyzer_h
#include "ItemDocumentationAnalyzer.h"
#endif

namespace doctorj 
{
    class AstModifierList;
    class AstTaggedComment;
    class Reporter;

    class ClassInterfaceDocumentationAnalyzer : public ItemDocumentationAnalyzer 
    {
    public:
        ClassInterfaceDocumentationAnalyzer(Reporter* const reporter,
                                            AstModifierList* const modifiers);

        /**
         * Does no checks. Useful only for extracting static data and invoking
         * methods that require no code.
         */
        ClassInterfaceDocumentationAnalyzer();

        virtual ~ClassInterfaceDocumentationAnalyzer();

        /**
         * Checks if the tagged comment is valid for a class or interface.
         */
        virtual bool handleTag(AstTaggedComment* const tc);

        /**
         * Checks the author tag.
         */
        virtual void checkAuthor(AstTaggedComment* const tc);

        /**
         * Checks the version tag.
         */
        virtual void checkVersion(AstTaggedComment* const tc);

    private:
        /**
         * Whether we've already processed a version tag.
         */
        bool seenVersion_;

    };
}

#endif //! ClassInterfaceDocumentationAnalyzer_h
