#ifndef ConstructorDocumentationAnalyzer_h
#include "ConstructorDocumentationAnalyzer.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef DocumentationErrors_h
#include "DocumentationErrors.h"
#endif

using namespace doctorj;

ConstructorDocumentationAnalyzer::ConstructorDocumentationAnalyzer(Reporter* const reporter,
                                                                   AstConstructorDeclarator* const ctor, 
                                                                   AstModifierList* const modifiers,
                                                                   AstFormalParameterList* const parameters,
                                                                   AstThrowsNameList* const throwsList) :
        MethodCtorDocumentationAnalyzer(reporter, modifiers, parameters, throwsList),
        ctor_(ctor)
{
    check();
}

ConstructorDocumentationAnalyzer::~ConstructorDocumentationAnalyzer()
{
}

void ConstructorDocumentationAnalyzer::checkReturn(AstTaggedComment* const tc) 
{
    ErrorReturnUsedWithConstructor err(reporter(), tc);
    err.process();
}

string ConstructorDocumentationAnalyzer::type() const
{
    return "constructor";
}

AstItem* ConstructorDocumentationAnalyzer::getSubject()
{
    AstIdentifier* subject = ctor_ == NULL ? NULL : ctor_->getIdentifier();
    return subject;
}

AstFormalParameterList* ConstructorDocumentationAnalyzer::getFormalParameterList()
{
    AstConstructorDeclaratorParams* cdp = dynamic_cast<AstConstructorDeclaratorParams*>(ctor_);
    return cdp == NULL ? NULL : cdp->getFormalParameterList();
}

AstNoncode* ConstructorDocumentationAnalyzer::leadingNoncode()
{
    return ctor_ == NULL ? NULL : ctor_->parent()->leadingNoncode();
}

void ConstructorDocumentationAnalyzer::checkUndocumentedReturn()
{
    // nothing to do, since constructors don't have returns (this may indicate a
    // poor design on my part here).
}

ErrorInvalidJavadocTag* ConstructorDocumentationAnalyzer::makeUnknownTagError(AstItem* const item, 
                                                                              const string& tag) const
{
    return new ErrorInvalidJavadocTagCtor(reporter(), item, tag);
}
