#ifndef ConstructorDocumentationAnalyzer_h
#define ConstructorDocumentationAnalyzer_h

#ifndef MethodCtorDocumentationAnalyzer_h
#include "MethodCtorDocumentationAnalyzer.h"
#endif

namespace doctorj 
{
    class AstConstructorDeclarator;

    class ConstructorDocumentationAnalyzer : public MethodCtorDocumentationAnalyzer 
    {
    public:
        ConstructorDocumentationAnalyzer(Reporter* const reporter,
                                         AstConstructorDeclarator* const ctor, 
                                         AstModifierList* const modifiers,
                                         AstFormalParameterList* const parameters,
                                         AstThrowsNameList* const throwsList);

        virtual ~ConstructorDocumentationAnalyzer();

        /**
         * What type of object we're analyzing--constructor.
         */
        virtual string type() const;

        /**
         * The identifier (subject) of what we're analyzing.
         */
        virtual AstItem* getSubject();

        /**
         * The parameters of what we're analyzing. NULL if no parameters.
         */
        virtual AstFormalParameterList* getFormalParameterList();

        /**
         * Complain about documenting a return type with a ctor.
         */
        virtual void checkReturn(AstTaggedComment* const tc);

        /**
         * Returns the noncode preceding the method.
         */
        virtual AstNoncode* leadingNoncode();

        /**
         * A no-op, since returns don't apply to ctors.
         */
        virtual void checkUndocumentedReturn();
        
        /**
         * Creates the error for the usage of an invalid tag with an interface.
         */
        virtual ErrorInvalidJavadocTag* makeUnknownTagError(AstItem* const item, 
                                                            const string& tag) const;
        
    private:

        AstConstructorDeclarator* ctor_;

    };
}

#endif //! ConstructorDocumentationAnalyzer_h
