#ifndef DocUserPreferences_h
#define DocUserPreferences_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace std;

namespace doctorj
{
    /**
     * The user's preferences, a singleton since there is only one user.
     */
    class DocUserPreferences
    {
    public:
        friend ostream& operator<<(ostream& os, const DocUserPreferences& up);
        
        static DocUserPreferences* get();

        /**
         * Tags defined by the user.
         */
        vector<string> userDefinedTags;

        /**
         * The dictionaries to be used.
         */
        vector<string> dictionaries;

        /**
         * User-defined valid words, used in addition to the dictionaries.
         */
        vector<string> validWords;

        /**
         * Default author.
         */
        string defaultAuthorName;

        /**
         * Default version.
         */
        string defaultVersion;

        /**
         * Default field description.
         */
        string defaultFieldDescription;

        /**
         * Default interface description.
         */
        string defaultInterfaceDescription;

        /**
         * Default class description.
         */
        string defaultClassDescription;

        /**
         * Default method description.
         */
        string defaultMethodDescription;

        /**
         * Default parameter description.
         */
        string defaultParameterDescription;

        /**
         * Default exception (throw) description.
         */
        string defaultExceptionDescription;

        /**
         * Default constructor description.
         */
        string defaultConstructorDescription;

    protected:
        DocUserPreferences();

        virtual ~DocUserPreferences();

        static DocUserPreferences* instance_;

    };
}

#endif //! DocUserPreferences_h
