#ifndef DocumentationAnalyzer_h
#define DocumentationAnalyzer_h

#ifndef Processor_h
#include "Processor.h"
#endif

namespace doctorj
{
    class Reporter;

    class DocumentationAnalyzer : public Processor
    {
    public:
        DocumentationAnalyzer(Reporter* const reporter);

        virtual ~DocumentationAnalyzer();

        virtual void process(AstClassDeclarationModsBaseless* const c);

        virtual void process(AstClassDeclarationModsExtends* const c);

        virtual void process(AstClassDeclarationModsExtendsImplements* const c);

        virtual void process(AstClassDeclarationModsImplements* const c);

        virtual void process(AstClassDeclarationNoModsBaseless* const c);

        virtual void process(AstClassDeclarationNoModsExtends* const c);

        virtual void process(AstClassDeclarationNoModsExtendsImplements* const c);

        virtual void process(AstClassDeclarationNoModsImplements* const c);

	virtual void process(AstClassMemberDeclarationNoModsNoExtendsNoImplements* const c);

	virtual void process(AstClassMemberDeclarationNoModsNoExtendsImplements* const c);

	virtual void process(AstClassMemberDeclarationNoModsExtendsNoImplements* const c);

	virtual void process(AstClassMemberDeclarationNoModsExtendsImplements* const c);

	virtual void process(AstClassMemberDeclarationModsNoExtendsNoImplements* const c);

	virtual void process(AstClassMemberDeclarationModsNoExtendsImplements* const c);

	virtual void process(AstClassMemberDeclarationModsExtendsNoImplements* const c);

	virtual void process(AstClassMemberDeclarationModsExtendsImplements* const c);
        
        virtual void process(AstConstructorDeclarationModsNoThrows* const c);

        virtual void process(AstConstructorDeclarationModsThrows* const c);

        virtual void process(AstConstructorDeclarationNoModsNoThrows* const c);

        virtual void process(AstConstructorDeclarationNoModsThrows* const c);

        virtual void process(AstFieldDeclarationMods* const f);

        virtual void process(AstFieldDeclarationNoMods* const f);

        virtual void process(AstInterfaceDeclarationModsExtends* const i);

        virtual void process(AstInterfaceDeclarationModsNoExtends* const i);

        virtual void process(AstInterfaceDeclarationNoModsExtends* const i);

        virtual void process(AstInterfaceDeclarationNoModsNoExtends* const i);

        virtual void process(AstMethodHeaderTypeModsNoThrows* const m);

        virtual void process(AstMethodHeaderTypeModsThrows* const m);

        virtual void process(AstMethodHeaderTypeNoModsNoThrows* const m);

        virtual void process(AstMethodHeaderTypeNoModsThrows* const m);

        virtual void process(AstMethodHeaderVoidModsNoThrows* const m);

        virtual void process(AstMethodHeaderVoidModsThrows* const m);

        virtual void process(AstMethodHeaderVoidNoModsNoThrows* const m);

        virtual void process(AstMethodHeaderVoidNoModsThrows* const m);

    private:

        Reporter* const reporter_;

    };
}

#endif //! DocumentationAnalyzer_h
