#ifndef InterfaceDocumentationAnalyzer_h
#define InterfaceDocumentationAnalyzer_h

#ifndef ClassInterfaceDocumentationAnalyzer_h
#include "ClassInterfaceDocumentationAnalyzer.h"
#endif

namespace doctorj 
{
    class AstInterfaceDeclaration;
    class AstItem;
    class AstModifierList;
    class AstNoncode;
    class Reporter;

    class InterfaceDocumentationAnalyzer : public ClassInterfaceDocumentationAnalyzer 
    {
    public:
        /**
         * Useful only for extracting the valid tags, and other such methods
         * that do not require a class, reporter, etc. Performs no checks.
         */
        InterfaceDocumentationAnalyzer();

        /**
         * The more useful constructor.
         */
        InterfaceDocumentationAnalyzer(Reporter* const reporter,
                                       AstInterfaceDeclaration* const iface,
                                       AstModifierList* const modifiers);

        virtual ~InterfaceDocumentationAnalyzer();

        /**
         * Returns the noncode preceding the class declaration. This noncode
         * should contain the Javadoc comment, if any.
         */
        virtual AstNoncode* leadingNoncode();

        /**
         * What type of object we're analyzing, a "class".
         */
        virtual string type() const;

        /**
         * The identifier of what we're analyzing.
         */
        virtual AstItem* getSubject();

        /**
         * Creates the error for the usage of an invalid tag with an interface.
         */
        virtual ErrorInvalidJavadocTag* makeUnknownTagError(AstItem* const item, 
                                                            const string& tag) const;
        
    private:
        /**
         * The interface declaration being analyzed.
         */
        AstInterfaceDeclaration* interface_;

    };
}

#endif //! InterfaceDocumentationAnalyzer_h
