#ifndef MethodCtorDocumentationAnalyzer_h
#define MethodCtorDocumentationAnalyzer_h

#ifndef ItemDocumentationAnalyzer_h
#include "ItemDocumentationAnalyzer.h"
#endif

#ifndef ParameterDocumentationAnalyzer_h
#include "ParameterDocumentationAnalyzer.h"
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj 
{
    class AstFormalParameterList;
    class AstModifierList;
    class AstTaggedComment;
    class AstThrowsNameList;
    class ExceptionDocumentationAnalyzer;
    class Reporter;

    class MethodCtorDocumentationAnalyzer : public ItemDocumentationAnalyzer 
    {
    public:
        MethodCtorDocumentationAnalyzer(Reporter* const reporter,
                                        AstModifierList* const modifiers,
                                        AstFormalParameterList* const parameters,
                                        AstThrowsNameList* const throwsList);

        virtual ~MethodCtorDocumentationAnalyzer();

        /**
         * The parameters of what we're analyzing.
         */
        virtual AstFormalParameterList* getFormalParameterList() = 0;

        /**
         * Checks if the tagged comment is valid for a methor or constructor.
         */
        virtual bool handleTag(AstTaggedComment* const tc);

        /**
         * Checks the return tag against the return type (which of course
         * doesn't apply to constructors, only methods).
         */
        virtual void checkReturn(AstTaggedComment* const tc) = 0;

        /**
         * Checks the @param tag.
         */
        virtual void checkParameter(AstTaggedComment* const tc);

        /**
         * Checks the @exception tag.
         */
        virtual void checkException(AstTaggedComment* const tc);

        /**
         * Checks the @serialData tag.
         */
        virtual void checkSerialData(AstTaggedComment* const tc);

        /**
         * Checks the @throws tag.
         */
        virtual void checkThrows(AstTaggedComment* const tc);

        /**
         * Checks for undocumented return, parameters, and throws (exceptions).
         */
        virtual void checkUndocumented();

        /**
         * Checks for undocumented parameters (arguments).
         */
        virtual void checkUndocumentedParams();

        /**
         * Checks for undocumented throws (exceptions).
         */
        virtual void checkUndocumentedThrows();

        /**
         * Checks for an undocumented return type.
         */
        virtual void checkUndocumentedReturn() = 0;

    protected:

        ExceptionDocumentationAnalyzer* getExceptionAnalyzer();

    private:

        /**
         * The list of exceptions in the code.
         */
        AstThrowsNameList* const throwsList_;

        /**
         * The analyzer of exceptions.
         */
        ExceptionDocumentationAnalyzer* exceptionAnalyzer_;

        /**
         * The analyzer of parameters.
         */
        ParameterDocumentationAnalyzer parameterAnalyzer_;

    };
}

#endif //! MethodCtorDocumentationAnalyzer_h
